/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter;

import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceDiagnosisCode;
import gov.cms.oce.model.external.OceHcpcsModifier;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.model.external.OceValueCode;
import gov.cms.oce.util.StringUtilities;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceClaimToStringClaimConverter {
    private static final Logger logger = LoggerFactory.getLogger(OceClaimToStringClaimConverter.class);

    private final char[] createClaimBuffer() {
        char[] tempOutputBuffer = new char[97820];
        int i2 = 97820;
        while (-1 < --i2) {
            tempOutputBuffer[i2] = 32;
        }
        return tempOutputBuffer;
    }

    public final void addEditList(char[] buffer, int bufferOffset, List<String> editList, int editCount) {
        for (int i2 = 0; i2 < editCount; ++i2) {
            if (i2 >= editList.size()) continue;
            String edit = editList.get(i2);
            StringUtilities.pad(edit, buffer, bufferOffset + i2 * 3, 3, StringUtilities.Direction.LEFT, '0');
        }
    }

    public final void convertLine(char[] buffer, int lineOffset, OceLineItem line) {
        if (line.getServiceDate() == null && line.getRevenueCode() == null && line.getHcpcs() == null) {
            return;
        }
        StringUtilities.pad(line.getPaymentApc(), buffer, lineOffset, 5, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(line.getHcpcsApc(), buffer, lineOffset + 5, 5, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(line.getStatusIndicator(), buffer, lineOffset + 10, 2, StringUtilities.Direction.LEFT, ' ');
        StringUtilities.pad(line.getPaymentIndicator(), buffer, lineOffset + 12, 2, StringUtilities.Direction.LEFT, ' ');
        StringUtilities.pad(line.getDiscountingFormula(), buffer, lineOffset + 14, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(line.getRejectionDenialFlag(), buffer, lineOffset + 15, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(line.getPackagingFlag(), buffer, lineOffset + 16, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(line.getPaymentAdjustmentFlag01(), buffer, lineOffset + 17, 2, StringUtilities.Direction.LEFT, ' ');
        StringUtilities.pad(line.getPaymentMethodFlag(), buffer, lineOffset + 19, 1, StringUtilities.Direction.LEFT, ' ');
        StringUtilities.pad(line.getUnitsOutput(), buffer, lineOffset + 20, 9, StringUtilities.Direction.LEFT, '0');
        this.addEditList(buffer, lineOffset + 29, line.getHcpcsEditList(), 30);
        StringUtilities.pad(line.getActionFlagOutput(), buffer, lineOffset + 119, 1, StringUtilities.Direction.LEFT, ' ');
        StringUtilities.pad(line.getCompositeAdjustmentFlag(), buffer, lineOffset + 120, 2, StringUtilities.Direction.RIGHT, ' ');
        List<OceHcpcsModifier> hcpcsModifierOutputList = line.getHcpcsModifierOutputList();
        for (int j = 0; j < 2; ++j) {
            String hcpcsModifier;
            if (j >= hcpcsModifierOutputList.size() || (hcpcsModifier = hcpcsModifierOutputList.get(j).getHcpcsModifier()) == null) continue;
            StringUtilities.pad(hcpcsModifier, buffer, lineOffset + 122 + j * 2, 2, StringUtilities.Direction.RIGHT, ' ');
        }
        StringUtilities.pad(line.getPaymentAdjustmentFlag02(), buffer, lineOffset + 126, 2, StringUtilities.Direction.LEFT, ' ');
        List<OceHcpcsModifier> hcpcsModifierInputList = line.getHcpcsModifierInputList();
        for (int j = 0; j < 5; ++j) {
            if (j >= hcpcsModifierInputList.size()) continue;
            List<String> modifierEditList = hcpcsModifierInputList.get(j).getEditList();
            this.addEditList(buffer, lineOffset + 128 + j * 12, modifierEditList, 4);
        }
        this.addEditList(buffer, lineOffset + 188, line.getServiceDateEditList(), 4);
        this.addEditList(buffer, lineOffset + 200, line.getRevenueEditList(), 5);
    }

    public final String convert(OceClaim claim) {
        char[] buffer = this.createClaimBuffer();
        StringUtilities.pad(claim.getProcessingInformation().getClaimId(), buffer, 0, 17, StringUtilities.Direction.RIGHT, ' ');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getClaimProcessedFlag()), buffer, 17, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getClaimDisposition()), buffer, 18, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getClaimRejectionDisposition()), buffer, 19, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getClaimDenialDisposition()), buffer, 20, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getClaimReturnToProviderDisposition()), buffer, 21, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getClaimSuspensionDisposition()), buffer, 22, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getLineRejectionDisposition()), buffer, 23, 1, StringUtilities.Direction.LEFT, '0');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getLineDenialDisposition()), buffer, 24, 1, StringUtilities.Direction.LEFT, '0');
        this.addEditList(buffer, 25, claim.getClaimRejectionEditList(), 4);
        this.addEditList(buffer, 37, claim.getClaimDenialEditList(), 8);
        this.addEditList(buffer, 61, claim.getClaimReturnToProviderEditList(), 30);
        this.addEditList(buffer, 151, claim.getClaimSuspensionEditList(), 16);
        this.addEditList(buffer, 199, claim.getLineRejectionEditList(), 12);
        this.addEditList(buffer, 235, claim.getLineDenialEditList(), 6);
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getApcReturnBufferFlag()), buffer, 253, 1, StringUtilities.Direction.LEFT, ' ');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getVersion()), buffer, 254, 8, StringUtilities.Direction.RIGHT, ' ');
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getNoppsBillFlag()), buffer, 262, 1, StringUtilities.Direction.LEFT, ' ');
        List<OceValueCode> valueCodeOutput = claim.getValueCodeOutputList();
        for (int i2 = 0; i2 < 10; ++i2) {
            if (i2 >= valueCodeOutput.size()) continue;
            OceValueCode oceValueCode = valueCodeOutput.get(i2);
            if (oceValueCode == null) {
                StringUtilities.pad("", buffer, 263 + i2 * 11 + 2, 9, StringUtilities.Direction.LEFT, '0');
                continue;
            }
            String code = oceValueCode.getCode();
            if (code == null || "".equals(code.trim())) {
                StringUtilities.pad(code, buffer, 263 + i2 * 11, 2, StringUtilities.Direction.RIGHT, ' ');
                StringUtilities.pad("", buffer, 263 + i2 * 11 + 2, 9, StringUtilities.Direction.LEFT, '0');
                continue;
            }
            StringUtilities.pad(code, buffer, 263 + i2 * 11, 2, StringUtilities.Direction.RIGHT, ' ');
            String value = oceValueCode.getValue();
            if (value == null || "".equals(value.trim())) {
                StringUtilities.pad("", buffer, 263 + i2 * 11 + 2, 9, StringUtilities.Direction.LEFT, '0');
                continue;
            }
            StringUtilities.pad(value, buffer, 263 + i2 * 11 + 2, 9, StringUtilities.Direction.LEFT, '0');
        }
        List<String> conditionCodeOutput = claim.getConditionCodeOutputList();
        for (int i3 = 0; i3 < 10; ++i3) {
            String conditionCode;
            if (i3 >= conditionCodeOutput.size() || (conditionCode = conditionCodeOutput.get(i3)) == null) continue;
            StringUtilities.pad(conditionCode, buffer, 373 + i3 * 2, 2, StringUtilities.Direction.RIGHT, ' ');
        }
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getProcessingInformation().getReturnCode()), buffer, 393, 2, StringUtilities.Direction.LEFT, ' ');
        List<OceDiagnosisCode> rvdxList = claim.getReasonForVisitDiagnosisCodeList();
        for (int i4 = 0; i4 < 3; ++i4) {
            OceDiagnosisCode oceDiagnosisCode;
            if (i4 >= rvdxList.size() || (oceDiagnosisCode = rvdxList.get(i4)) == null || oceDiagnosisCode.getEditList() == null) continue;
            this.addEditList(buffer, 395 + i4 * 24, rvdxList.get(i4).getEditList(), 8);
        }
        this.addEditList(buffer, 467, claim.getPrincipalDiagnosisCode().getEditList(), 8);
        List<OceDiagnosisCode> sdxList = claim.getSecondaryDiagnosisCodeList();
        for (int i5 = 0; i5 < 24; ++i5) {
            OceDiagnosisCode oceDiagnosisCode;
            if (i5 >= sdxList.size() || (oceDiagnosisCode = sdxList.get(i5)) == null || oceDiagnosisCode.getEditList() == null) continue;
            this.addEditList(buffer, 491 + i5 * 24, sdxList.get(i5).getEditList(), 8);
        }
        StringUtilities.pad(StringUtilities.toNonNullString(claim.getProcessingInformation().getLinesProcessed()), buffer, 1067, 3, StringUtilities.Direction.LEFT, '0');
        int lineLength = 215;
        int lineOffset = 1070;
        List<OceLineItem> lineItemList = claim.getLineItemList();
        for (int i6 = 0; i6 < 450; ++i6) {
            if (i6 >= lineItemList.size()) continue;
            this.convertLine(buffer, 1070 + i6 * 215, lineItemList.get(i6));
        }
        return new String(buffer);
    }
}

