/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter;

import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceDiagnosisCode;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.model.external.OceValueCode;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordModel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceClaimToTestClaimConverter {
    private static final Logger logger = LoggerFactory.getLogger(OceClaimToTestClaimConverter.class);
    private ClaimDefinition claimDefinition;

    public OceClaimToTestClaimConverter(ClaimDefinition claimDefinition) {
        this.claimDefinition = claimDefinition;
    }

    /*
     * WARNING - void declaration
     */
    public final ClaimModel convert(OceClaim claim) {
        void var31_54;
        int i2;
        String edit;
        String edit2;
        int i3;
        ClaimModel claimModel = new ClaimModel(this.claimDefinition);
        RecordDefinition cDef = this.claimDefinition.getRecord("C", 0);
        RecordDefinition dDef = this.claimDefinition.getRecord("D", 0);
        RecordDefinition eDef = this.claimDefinition.getRecord("E", 0);
        RecordDefinition fDef = this.claimDefinition.getRecord("F", 0);
        RecordDefinition lDef = this.claimDefinition.getRecord("L", 0);
        RecordDefinition mDef = this.claimDefinition.getRecord("M", 0);
        RecordDefinition nDef = this.claimDefinition.getRecord("N", 0);
        RecordDefinition oDef = this.claimDefinition.getRecord("O", 0);
        RecordDefinition pDef = this.claimDefinition.getRecord("P", 0);
        RecordDefinition qDef = this.claimDefinition.getRecord("Q", 0);
        RecordDefinition rDef = this.claimDefinition.getRecord("R", 0);
        RecordDefinition sDef = this.claimDefinition.getRecord("S", 0);
        RecordModel cRecord = new RecordModel(cDef);
        cRecord.set(cDef.getField("CType"), "C", 0);
        cRecord.set(cDef.getField("CId"), claim.getProcessingInformation().getClaimId(), 0);
        cRecord.set(cDef.getField("CAge"), claim.getAge(), 0);
        cRecord.set(cDef.getField("CSex"), claim.getSex(), 0);
        cRecord.set(cDef.getField("CStartDate"), claim.getDateStarted(), 0);
        cRecord.set(cDef.getField("CEndDate"), claim.getDateEnded(), 0);
        cRecord.set(cDef.getField("CBillType"), claim.getBillType(), 0);
        cRecord.set(cDef.getField("CNpiProviderId"), claim.getNationalProviderId(), 0);
        cRecord.set(cDef.getField("COscarProviderId"), claim.getCmsCertificationNumber(), 0);
        cRecord.set(cDef.getField("CPatientStatus"), claim.getPatientStatus(), 0);
        cRecord.set(cDef.getField("COppsFlag"), claim.getOppsFlag(), 0);
        for (int i4 = 0; i4 < claim.getOccurrenceCodeInputList().size() && i4 < 30; ++i4) {
            String occurrenceCode = claim.getOccurrenceCodeInputList().get(i4);
            cRecord.set(cDef.getField("COccurrenceCodes"), occurrenceCode, i4);
        }
        for (int i4 = 0; i4 < claim.getConditionCodeInputList().size() && i4 < 30; ++i4) {
            String conditionCode = claim.getConditionCodeInputList().get(i4);
            cRecord.set(cDef.getField("CConditionCodes"), conditionCode, i4);
        }
        cRecord.set(cDef.getField("CReceiptDate"), claim.getReceiptDate(), 0);
        cRecord.set(cDef.getField("CExtra"), claim.getProcessingInformation().getCommentData(), 0);
        claimModel.addRecord(cRecord);
        RecordModel dRecord = new RecordModel(dDef);
        dRecord.set(dDef.getField("DType"), "D", 0);
        dRecord.set(dDef.getField("DId"), claim.getProcessingInformation().getClaimId(), 0);
        for (int i5 = 0; i5 < claim.getReasonForVisitDiagnosisCodeList().size() && i5 < 3; ++i5) {
            OceDiagnosisCode diagnosisCode = claim.getReasonForVisitDiagnosisCodeList().get(i5);
            String tmpDiagnosisCode = StringUtilities.padRight(diagnosisCode.getDiagnosis(), 7, ' ');
            String tmpDiagnosisPoa = StringUtilities.padRight(diagnosisCode.getPresentOnAdmission(), 1, ' ');
            dRecord.set(dDef.getField("DDx"), tmpDiagnosisCode.concat(tmpDiagnosisPoa), i5);
        }
        String pdxDiagnosisCode = StringUtilities.padRight(claim.getPrincipalDiagnosisCode().getDiagnosis(), 7, ' ');
        String pdxDiagnosisPoa = StringUtilities.padRight(claim.getPrincipalDiagnosisCode().getPresentOnAdmission(), 1, ' ');
        dRecord.set(dDef.getField("DDx"), pdxDiagnosisCode.concat(pdxDiagnosisPoa), 3);
        for (int i6 = 0; i6 < claim.getSecondaryDiagnosisCodeList().size() && i6 < 24; ++i6) {
            OceDiagnosisCode diagnosisCode = claim.getSecondaryDiagnosisCodeList().get(i6);
            String tmpDiagnosisCode = StringUtilities.padRight(diagnosisCode.getDiagnosis(), 7, ' ');
            String tmpDiagnosisPoa = StringUtilities.padRight(diagnosisCode.getPresentOnAdmission(), 1, ' ');
            dRecord.set(dDef.getField("DDx"), tmpDiagnosisCode.concat(tmpDiagnosisPoa), i6 + 4);
        }
        claimModel.addRecord(dRecord);
        RecordModel eRecord = new RecordModel(eDef);
        int eValueCount = eDef.getField("EValueCodes").getCount();
        eRecord.set(eDef.getField("EType"), "E", 0);
        eRecord.set(eDef.getField("EId"), claim.getProcessingInformation().getClaimId(), 0);
        for (int i7 = 0; i7 < claim.getValueCodeInputList().size() && i7 < eValueCount; ++i7) {
            OceValueCode valueCode = claim.getValueCodeInputList().get(i7);
            eRecord.set(eDef.getField("EValueCodes"), valueCode.getCode() + valueCode.getValue(), i7);
        }
        claimModel.addRecord(eRecord);
        RecordModel fRecord = new RecordModel(fDef);
        int fValueCount = fDef.getField("FValueCodes").getCount();
        fRecord.set(fDef.getField("FType"), "F", 0);
        fRecord.set(fDef.getField("FId"), claim.getProcessingInformation().getClaimId(), 0);
        for (int i8 = eValueCount; i8 < claim.getValueCodeInputList().size() && i8 < eValueCount + fValueCount; ++i8) {
            OceValueCode valueCode = claim.getValueCodeInputList().get(i8);
            String tmpCode = StringUtilities.padLeft(valueCode.getCode(), 2, ' ');
            String tmpValue = StringUtilities.padLeft(valueCode.getValue(), 9, ' ');
            fRecord.set(fDef.getField("FValueCodes"), tmpCode.concat(tmpValue), i8 - eValueCount);
        }
        claimModel.addRecord(fRecord);
        int lineCounter = 0;
        for (OceLineItem lineItem : claim.getLineItemList()) {
            RecordModel lRecord = new RecordModel(lDef);
            lRecord.set(lDef.getField("LType"), "L", 0);
            lRecord.set(lDef.getField("LId"), claim.getProcessingInformation().getClaimId(), 0);
            String lineCounterString = StringUtilities.padLeft(++lineCounter + "", 3, '0');
            lRecord.set(lDef.getField("LLineNumber"), lineCounterString, 0);
            lRecord.set(lDef.getField("LProcedure"), lineItem.getHcpcs(), 0);
            for (int i9 = 0; i9 < lineItem.getHcpcsModifierInputList().size(); ++i9) {
                String hcpcsModifier = lineItem.getHcpcsModifierInputList().get(i9).getHcpcsModifier();
                String tmpHcpcsModifier = StringUtilities.padLeft(hcpcsModifier, 2, ' ');
                lRecord.set(lDef.getField("LModifier"), tmpHcpcsModifier, i9);
            }
            lRecord.set(lDef.getField("LServiceDate"), lineItem.getServiceDate(), 0);
            lRecord.set(lDef.getField("LRevenueCode"), lineItem.getRevenueCode(), 0);
            lRecord.set(lDef.getField("LServiceUnits"), lineItem.getUnitsInput(), 0);
            lRecord.set(lDef.getField("LCharge"), lineItem.getCharge(), 0);
            lRecord.set(lDef.getField("LLineItemActionFlag"), lineItem.getActionFlagInput(), 0);
            for (int i5 = 0; i5 < lineItem.getContractorEditBypassList().size(); ++i5) {
                String contractorEditBypass = lineItem.getContractorEditBypassList().get(i5);
                lRecord.set(lDef.getField("LCBEdits"), contractorEditBypass, i5);
            }
            lRecord.set(lDef.getField("LCBApc"), lineItem.getContractorApc(), 0);
            lRecord.set(lDef.getField("LCBServiceIndicator"), lineItem.getContractorStatusIndicator(), 0);
            lRecord.set(lDef.getField("LCBPaymentIndicator"), lineItem.getContractorPaymentIndicator(), 0);
            lRecord.set(lDef.getField("LCBDiscountingFormula"), lineItem.getContractorDiscountingFormula(), 0);
            lRecord.set(lDef.getField("LCBRejectionDenialFlag"), lineItem.getContractorRejectionDenialFlag(), 0);
            lRecord.set(lDef.getField("LCBPackagingFlag"), lineItem.getContractorPackagingFlag(), 0);
            lRecord.set(lDef.getField("LCBPaymentAdjustmentFlag01"), lineItem.getContractorPaymentAdjustmentFlag01(), 0);
            lRecord.set(lDef.getField("LCBPaymentMethodFlag"), lineItem.getContractorPaymentMethodFlag(), 0);
            lRecord.set(lDef.getField("LCBPaymentAdjustmentFlag02"), lineItem.getContractorPaymentAdjustmentFlag02(), 0);
            claimModel.addRecord(lRecord);
        }
        RecordModel mRecord = new RecordModel(this.claimDefinition.getRecord("M"));
        mRecord.set(mDef.getField("MType"), "M", 0);
        mRecord.set(mDef.getField("MId"), claim.getProcessingInformation().getClaimId(), 0);
        mRecord.set(mDef.getField("MClaimProcessingFlag"), claim.getClaimProcessedFlag(), 0);
        mRecord.set(mDef.getField("MClaimDisposition"), claim.getClaimDisposition(), 0);
        mRecord.set(mDef.getField("MClaimRejectionDisposition"), claim.getClaimRejectionDisposition(), 0);
        mRecord.set(mDef.getField("MClaimDenialDisposition"), claim.getClaimDenialDisposition(), 0);
        mRecord.set(mDef.getField("MClaimRTPDisposition"), claim.getClaimReturnToProviderDisposition(), 0);
        mRecord.set(mDef.getField("MClaimSuspensionDisposition"), claim.getClaimSuspensionDisposition(), 0);
        mRecord.set(mDef.getField("MLineItemRejectionDisposition"), claim.getLineRejectionDisposition(), 0);
        mRecord.set(mDef.getField("MLineItemDenialDisposition"), claim.getLineDenialDisposition(), 0);
        for (int i32 = 0; i32 < claim.getClaimRejectionEditList().size(); ++i32) {
            String edit22 = claim.getClaimRejectionEditList().get(i32);
            mRecord.set(mDef.getField("MClaimRejectionEdits"), edit22, i32);
        }
        for (i3 = 0; i3 < claim.getClaimDenialEditList().size(); ++i3) {
            edit2 = claim.getClaimDenialEditList().get(i3);
            mRecord.set(mDef.getField("MClaimDenialEdits"), edit2, i3);
        }
        for (i3 = 0; i3 < claim.getClaimReturnToProviderEditList().size(); ++i3) {
            edit2 = claim.getClaimReturnToProviderEditList().get(i3);
            mRecord.set(mDef.getField("MClaimRTPEdits"), edit2, i3);
        }
        for (i3 = 0; i3 < claim.getValueCodeOutputList().size(); ++i3) {
            OceValueCode oceValueCode = claim.getValueCodeOutputList().get(i3);
            String code = oceValueCode.getCode();
            String value = oceValueCode.getValue();
            if (code == null || "".equals(code.trim())) {
                code = "  ";
            }
            if (!"  ".equals(code) && (value == null || "".equals(value.trim()))) {
                value = "000000000";
            }
            mRecord.set(mDef.getField("MClaimValueCodes"), code + value, i3);
        }
        if (claim.getValueCodeOutputList().size() < 10) {
            for (i3 = claim.getValueCodeOutputList().size(); i3 < 10; ++i3) {
                mRecord.set(mDef.getField("MClaimValueCodes"), "           ", i3);
            }
        }
        claimModel.addRecord(mRecord);
        RecordModel nRecord = new RecordModel(this.claimDefinition.getRecord("N"));
        nRecord.set(nDef.getField("NType"), "N", 0);
        nRecord.set(nDef.getField("NId"), claim.getProcessingInformation().getClaimId(), 0);
        for (int i22 = 0; i22 < claim.getClaimSuspensionEditList().size(); ++i22) {
            edit = claim.getClaimSuspensionEditList().get(i22);
            nRecord.set(nDef.getField("NClaimSuspensionEdits"), edit, i22);
        }
        for (i2 = 0; i2 < claim.getLineRejectionEditList().size(); ++i2) {
            edit = claim.getLineRejectionEditList().get(i2);
            nRecord.set(nDef.getField("NLineItemRejectionEdits"), edit, i2);
        }
        for (i2 = 0; i2 < claim.getLineDenialEditList().size(); ++i2) {
            edit = claim.getLineDenialEditList().get(i2);
            nRecord.set(nDef.getField("NLineItemDenialEdits"), edit, i2);
        }
        nRecord.set(nDef.getField("NApcReturnBufferFlag"), claim.getApcReturnBufferFlag(), 0);
        nRecord.set(nDef.getField("NNpiProviderId"), claim.getNationalProviderId(), 0);
        nRecord.set(nDef.getField("NOscarProviderId"), claim.getCmsCertificationNumber(), 0);
        nRecord.set(nDef.getField("NLineItemCount"), "" + claim.getProcessingInformation().getLinesProcessed(), 0);
        nRecord.set(nDef.getField("NVersion"), claim.getProcessingInformation().getVersion(), 0);
        nRecord.set(nDef.getField("NPatientStatus"), claim.getPatientStatus(), 0);
        nRecord.set(nDef.getField("NOppsFlag"), claim.getOppsFlag(), 0);
        nRecord.set(nDef.getField("NNonOppsBillFlag"), claim.getNoppsBillFlag(), 0);
        for (i2 = 0; i2 < claim.getConditionCodeOutputList().size(); ++i2) {
            String conditionCode = claim.getConditionCodeOutputList().get(i2);
            nRecord.set(nDef.getField("NConditionCodes"), conditionCode, i2);
        }
        if (claim.getProcessingInformation().getReturnCode() == null) {
            nRecord.set(nDef.getField("NReturnCode"), "0", 0);
        } else {
            nRecord.set(nDef.getField("NReturnCode"), "" + claim.getProcessingInformation().getReturnCode(), 0);
        }
        claimModel.addRecord(nRecord);
        int editCounter = 0;
        RecordModel oRecord = new RecordModel(this.claimDefinition.getRecord("O"));
        oRecord.set(oDef.getField("OType"), "O", 0);
        oRecord.set(oDef.getField("OId"), claim.getProcessingInformation().getClaimId(), 0);
        for (int i10 = 0; i10 < claim.getReasonForVisitDiagnosisCodeList().size() && i10 < 3; ++i10) {
            List<String> editList = claim.getReasonForVisitDiagnosisCodeList().get(i10).getEditList();
            if (editList.isEmpty()) continue;
            editCounter = 0;
            for (String string : editList) {
                oRecord.set(oDef.getField("ODiagnosis" + (i10 + 1) + "Edits"), string, editCounter);
                ++editCounter;
            }
        }
        List<String> principalDiagnosisEditList = claim.getPrincipalDiagnosisCode().getEditList();
        editCounter = 0;
        for (String edit4 : principalDiagnosisEditList) {
            oRecord.set(oDef.getField("ODiagnosis4Edits"), edit4, editCounter);
            ++editCounter;
        }
        for (int i11 = 0; i11 < claim.getSecondaryDiagnosisCodeList().size() && i11 < 5; ++i11) {
            List<String> secondaryDiagnosisCodeEditList = claim.getSecondaryDiagnosisCodeList().get(i11).getEditList();
            editCounter = 0;
            for (String edit5 : secondaryDiagnosisCodeEditList) {
                oRecord.set(oDef.getField("ODiagnosis" + (i11 + 5) + "Edits"), edit5, editCounter);
                ++editCounter;
            }
        }
        claimModel.addRecord(oRecord);
        RecordModel pRecord = new RecordModel(this.claimDefinition.getRecord("P"));
        pRecord.set(pDef.getField("PType"), "P", 0);
        pRecord.set(pDef.getField("PId"), claim.getProcessingInformation().getClaimId(), 0);
        boolean editPresentInP = false;
        int n = 5;
        while (var31_54 < claim.getSecondaryDiagnosisCodeList().size() && var31_54 < 14) {
            OceDiagnosisCode currentDx = claim.getSecondaryDiagnosisCodeList().get((int)var31_54);
            if (currentDx.getDiagnosis() != null && !"".equals(currentDx.getDiagnosis().trim())) {
                editPresentInP = true;
            }
            List<String> editList = currentDx.getEditList();
            editCounter = 0;
            for (String edit6 : editList) {
                pRecord.set(pDef.getField("PDiagnosis" + (int)(var31_54 + 5) + "Edits"), edit6, editCounter);
                ++editCounter;
            }
            ++var31_54;
        }
        if (editPresentInP) {
            claimModel.addRecord(pRecord);
        }
        RecordModel recordModel = new RecordModel(this.claimDefinition.getRecord("Q"));
        recordModel.set(qDef.getField("QType"), "Q", 0);
        recordModel.set(qDef.getField("QId"), claim.getProcessingInformation().getClaimId(), 0);
        boolean editPresentInQ = false;
        for (int i13 = 14; i13 < claim.getSecondaryDiagnosisCodeList().size() && i13 < 24; ++i13) {
            OceDiagnosisCode currentDx = claim.getSecondaryDiagnosisCodeList().get(i13);
            if (currentDx.getDiagnosis() != null && !"".equals(currentDx.getDiagnosis().trim())) {
                editPresentInQ = true;
            }
            List<String> editList = currentDx.getEditList();
            editCounter = 0;
            for (String string : editList) {
                recordModel.set(qDef.getField("QDiagnosis" + (i13 + 5) + "Edits"), string, editCounter);
                ++editCounter;
            }
        }
        if (editPresentInQ) {
            if (!editPresentInP) {
                claimModel.addRecord(pRecord);
            }
            claimModel.addRecord(recordModel);
        }
        lineCounter = 0;
        for (OceLineItem lineItem : claim.getLineItemList()) {
            void var38_73;
            RecordModel rRecord = new RecordModel(this.claimDefinition.getRecord("R"));
            rRecord.set(rDef.getField("RType"), "R", 0);
            rRecord.set(rDef.getField("RId"), claim.getProcessingInformation().getClaimId(), 0);
            String lineCounterString = StringUtilities.padLeft(String.valueOf(++lineCounter), 3, '0');
            rRecord.set(rDef.getField("RLineNumber"), lineCounterString, 0);
            rRecord.set(rDef.getField("RPaymentApc"), lineItem.getPaymentApc(), 0);
            rRecord.set(rDef.getField("RHcpcsApc"), lineItem.getHcpcsApc(), 0);
            rRecord.set(rDef.getField("RServiceIndicator"), lineItem.getStatusIndicator(), 0);
            rRecord.set(rDef.getField("RPaymentIndicator"), lineItem.getPaymentIndicator(), 0);
            rRecord.set(rDef.getField("RDiscountingFormula"), lineItem.getDiscountingFormula(), 0);
            rRecord.set(rDef.getField("RRejectionDenialFlag"), lineItem.getRejectionDenialFlag(), 0);
            rRecord.set(rDef.getField("RPackagingFlag"), lineItem.getPackagingFlag(), 0);
            rRecord.set(rDef.getField("RPaymentAdjustmentFlag01"), lineItem.getPaymentAdjustmentFlag01(), 0);
            rRecord.set(rDef.getField("RPaymentMethodFlag"), lineItem.getPaymentMethodFlag(), 0);
            rRecord.set(rDef.getField("RPaymentAdjustmentFlag02"), lineItem.getPaymentAdjustmentFlag02(), 0);
            rRecord.set(rDef.getField("RServiceUnits"), lineItem.getUnitsOutput(), 0);
            editCounter = 0;
            for (String string : lineItem.getHcpcsEditList()) {
                rRecord.set(rDef.getField("RProcedureEdits"), string, editCounter++);
            }
            rRecord.set(rDef.getField("RHcpcs"), lineItem.getHcpcs(), 0);
            if (lineItem.getActionFlagOutput() == null) {
                rRecord.set(rDef.getField("RLineItemActionFlag"), "0", 0);
            } else {
                rRecord.set(rDef.getField("RLineItemActionFlag"), lineItem.getActionFlagOutput(), 0);
            }
            rRecord.set(rDef.getField("RCompositeAdjustmentFlag"), lineItem.getCompositeAdjustmentFlag(), 0);
            claimModel.addRecord(rRecord);
            RecordModel recordModel2 = new RecordModel(this.claimDefinition.getRecord("S"));
            recordModel2.set(sDef.getField("SType"), "S", 0);
            recordModel2.set(sDef.getField("SId"), claim.getProcessingInformation().getClaimId(), 0);
            recordModel2.set(sDef.getField("SLineNumber"), String.valueOf(lineCounterString), 0);
            editCounter = 0;
            for (String string : lineItem.getServiceDateEditList()) {
                recordModel2.set(sDef.getField("SDateEdits"), string, editCounter++);
            }
            boolean bl = false;
            while (var38_73 < lineItem.getHcpcsModifierInputList().size() && var38_73 < 5) {
                editCounter = 0;
                for (String edit10 : lineItem.getHcpcsModifierInputList().get((int)var38_73).getEditList()) {
                    recordModel2.set(sDef.getField("SModifierEdits" + (int)(var38_73 + true)), edit10, editCounter);
                    ++editCounter;
                }
                ++var38_73;
            }
            editCounter = 0;
            for (String string : lineItem.getRevenueEditList()) {
                recordModel2.set(sDef.getField("SRevenueEdits"), string, editCounter++);
            }
            recordModel2.set(sDef.getField("SCharge"), lineItem.getCharge(), 0);
            claimModel.addRecord(recordModel2);
        }
        return claimModel;
    }
}

