/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter;

import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimDefinitionLoader;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.FieldDefinition;
import gov.cms.oce.util.converter.rsc.FieldDefinitionLoader;
import gov.cms.oce.util.converter.rsc.InvalidRecordException;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordDefinitionLoader;
import gov.cms.oce.util.converter.rsc.RecordModel;
import gov.cms.oce.util.converter.rsc.TestClaimFileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestCaseInputConverter {
    private static final Logger logger = LoggerFactory.getLogger(TestCaseInputConverter.class);
    private final String emptyLine;
    private String fieldDefinitionFile = "/claim-def/field.def";
    private String recordDefinitionFile = "/claim-def/record.def";
    private String claimDefinitionFile = "/claim-def/claim.def";
    private ClaimDefinition claimDefinition;

    public TestCaseInputConverter() {
        char[] tmpEmptyLine = new char[76];
        for (int i2 = 0; i2 < 76; ++i2) {
            tmpEmptyLine[i2] = 32;
        }
        this.emptyLine = new String(tmpEmptyLine);
    }

    public final void setFieldDefinitionFile(String filePath) {
        this.fieldDefinitionFile = filePath;
    }

    public final void setRecordDefinitionFile(String filePath) {
        this.recordDefinitionFile = filePath;
    }

    public final void setClaimDefinitionFile(String filePath) {
        this.claimDefinitionFile = filePath;
    }

    public final void loadClaimDefinition() throws IOException {
        this.claimDefinition = new ClaimDefinitionLoader(this.claimDefinitionFile, new RecordDefinitionLoader(this.recordDefinitionFile, new FieldDefinitionLoader(this.fieldDefinitionFile).load()).load()).load().getItem(0);
    }

    public final void printDefinitionTree(ClaimDefinition definition) {
        logger.debug("--- START TREE ---");
        logger.debug("CLAIM ID = \"{}\"", (Object)definition.getId());
        for (RecordDefinition record : definition.getRecords()) {
            logger.debug("RECORD ID = \"{}\"", (Object)record.getId());
            for (FieldDefinition field : record.getFields()) {
                logger.debug("FIELD ID = \"{}\"", (Object)field.getId());
            }
        }
        logger.debug("--- END TREE ---");
    }

    public final String getAggregate(String[] list) {
        if (list == null) {
            return "";
        }
        StringBuilder tmp = new StringBuilder();
        int count = 0;
        for (String s : list) {
            ++count;
            tmp.append(s);
        }
        return count < 1 ? "" : tmp.toString();
    }

    public final void convert(String inputFilePath, String outputFilePath) throws IOException {
        this.loadClaimDefinition();
        try (FileWriter w = new FileWriter(outputFilePath);){
            int testCaseCount = 0;
            ClaimModel claim = null;
            TestClaimFileReader reader = new TestClaimFileReader(inputFilePath, this.claimDefinition);
            RecordDefinition cDef = this.claimDefinition.getRecord("C", 0);
            RecordDefinition dDef = this.claimDefinition.getRecord("D", 0);
            RecordDefinition eDef = this.claimDefinition.getRecord("E", 0);
            RecordDefinition fDef = this.claimDefinition.getRecord("F", 0);
            RecordDefinition lDef = this.claimDefinition.getRecord("L", 0);
            reader.open();
            while (true) {
                try {
                    while ((claim = reader.next()) != null) {
                        int i2;
                        RecordModel fRecord;
                        RecordModel eRecord;
                        ++testCaseCount;
                        RecordModel cRecord = claim.getRecord("C", 0);
                        w.write(cRecord.get(cDef.getField("CId"), 0));
                        w.write(cRecord.get(cDef.getField("CAge"), 0));
                        w.write(cRecord.get(cDef.getField("CSex"), 0));
                        w.write(cRecord.get(cDef.getField("CStartDate"), 0));
                        w.write(cRecord.get(cDef.getField("CEndDate"), 0));
                        w.write(cRecord.get(cDef.getField("CBillType"), 0));
                        w.write(cRecord.get(cDef.getField("CNpiProviderId"), 0));
                        w.write(cRecord.get(cDef.getField("COscarProviderId"), 0));
                        w.write(cRecord.get(cDef.getField("CPatientStatus"), 0));
                        w.write(cRecord.get(cDef.getField("COppsFlag"), 0));
                        w.write(this.getAggregate(cRecord.get(cDef.getField("COccurrenceCodes"))));
                        w.write(this.getAggregate(cRecord.get(cDef.getField("CConditionCodes"))));
                        w.write(cRecord.get(cDef.getField("CReceiptDate"), 0));
                        RecordModel dRecord = claim.getRecord("D", 0);
                        if (dRecord != null) {
                            w.write(this.getAggregate(dRecord.get(dDef.getField("DDx"))));
                        }
                        if ((eRecord = claim.getRecord("E", 0)) != null) {
                            w.write(this.getAggregate(eRecord.get(eDef.getField("EValueCodes"))));
                        }
                        if ((fRecord = claim.getRecord("F", 0)) != null) {
                            w.write(this.getAggregate(fRecord.get(fDef.getField("FValueCodes"))));
                        }
                        w.write(" ");
                        List<RecordModel> lRecords = claim.getRecords("L");
                        for (i2 = 0; i2 < lRecords.size(); ++i2) {
                            RecordModel lRecord = lRecords.get(i2);
                            w.write(lRecord.get(lDef.getField("LServiceDate"), 0));
                            w.write(lRecord.get(lDef.getField("LRevenueCode"), 0));
                            w.write(lRecord.get(lDef.getField("LProcedure"), 0));
                            w.write(this.getAggregate(lRecord.get(lDef.getField("LModifier"))));
                            w.write(lRecord.get(lDef.getField("LServiceUnits"), 0));
                            w.write(lRecord.get(lDef.getField("LCharge"), 0));
                            w.write(lRecord.get(lDef.getField("LLineItemActionFlag"), 0));
                            w.write(this.getAggregate(lRecord.get(lDef.getField("LCBEdits"))));
                            w.write(lRecord.get(lDef.getField("LCBApc"), 0));
                            w.write(lRecord.get(lDef.getField("LCBServiceIndicator"), 0));
                            w.write(lRecord.get(lDef.getField("LCBPaymentIndicator"), 0));
                            w.write(lRecord.get(lDef.getField("LCBDiscountingFormula"), 0));
                            w.write(lRecord.get(lDef.getField("LCBRejectionDenialFlag"), 0));
                            w.write(lRecord.get(lDef.getField("LCBPackagingFlag"), 0));
                            w.write(lRecord.get(lDef.getField("LCBPaymentAdjustmentFlag01"), 0));
                            w.write(lRecord.get(lDef.getField("LCBPaymentMethodFlag"), 0));
                            w.write(lRecord.get(lDef.getField("LCBPaymentAdjustmentFlag02"), 0));
                        }
                        for (i2 = lRecords.size(); i2 < 450; ++i2) {
                            w.write(this.emptyLine);
                        }
                        w.write("\r\n");
                    }
                }
                catch (InvalidRecordException e) {
                    logger.error("Failed to read claim data.", e);
                    continue;
                }
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\"{}\" claims written.", (Object)testCaseCount);
            }
        }
        catch (Exception e) {
            logger.error("Exception:", e);
        }
    }

    public static final void main(String[] v) throws IOException {
        TestCaseInputConverter c = new TestCaseInputConverter();
        c.convert(v[0], v[1]);
    }
}

