/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.AbstractDefinitionLoader;
import gov.cms.oce.util.converter.rsc.DefinitionList;
import gov.cms.oce.util.converter.rsc.DefinitionReader;
import gov.cms.oce.util.converter.rsc.FieldDefinition;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordDefinitionLoader
extends AbstractDefinitionLoader<RecordDefinition> {
    public static final int GROUP = 0;
    public static final int INPUT_OUTPUT = 1;
    public static final int FIELDS = 2;
    private static final Logger logger = LoggerFactory.getLogger(RecordDefinitionLoader.class);
    private DefinitionList<FieldDefinition> lookupList;

    public RecordDefinitionLoader() {
    }

    public RecordDefinitionLoader(String filePath) {
        super(filePath);
    }

    public RecordDefinitionLoader(String filePath, DefinitionList<FieldDefinition> lookupList) {
        super(filePath);
        this.lookupList = lookupList;
    }

    public final DefinitionList<FieldDefinition> getLookupList() {
        return this.lookupList;
    }

    public final void setLookupList(DefinitionList<FieldDefinition> lookupList) {
        this.lookupList = lookupList;
    }

    @Override
    public final DefinitionList<RecordDefinition> load() throws IOException {
        DefinitionReader properties = new DefinitionReader();
        properties.load(this.filePath);
        for (Map.Entry<String, String> property : properties.getPropertyMap().entrySet()) {
            String[] values = property.getValue().split(",", 0);
            if (logger.isTraceEnabled()) {
                logger.trace("ID: \"{}\".", (Object)property.getKey());
                for (int i2 = 0; i2 < values.length; ++i2) {
                    logger.trace("FIELD: \"{}\".", (Object)values[i2].trim());
                }
            }
            ArrayList<FieldDefinition> list = new ArrayList<FieldDefinition>();
            block2: for (int i3 = 2; i3 < values.length; ++i3) {
                String key = values[i3].trim();
                for (FieldDefinition field : this.lookupList.getList()) {
                    if (!key.equals(field.getId())) continue;
                    list.add(field);
                    continue block2;
                }
            }
            String direction = values[1].trim().toUpperCase();
            this.definitionList.add(new RecordDefinition(property.getKey(), values[0].trim(), "I".equals(direction), "O".equals(direction), list));
        }
        return this.definitionList;
    }
}

