/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.DaySpan;
import gov.cms.oce.util.Navigator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowTest
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(WindowTest.class);

    private final void runFollowingWindowTest(Navigator navigator, int span) {
        logger.error("---------------");
        List<DaySpan> twoDayWindow = navigator.getFollowingDayWindowList(span);
        logger.error("[Following] Window Day Span={}", (Object)span);
        for (DaySpan daySpan : twoDayWindow) {
            logger.error("Window Start Date={}, Index={}", (Object)daySpan.getDate(), (Object)daySpan.getIndex());
            for (Day day : daySpan.getList()) {
                logger.error("Day Start Date={}, Index={}, line count={}", day.getDate(), day.getIndex(), day.getLineItemList().size());
                for (LineItemInternal line : day.getLineItemList()) {
                    logger.error("Line {}", (Object)line.getDay().getLineIndex(line));
                }
            }
        }
    }

    private final void runPrecedingWindowTest(Navigator navigator, int span) {
        logger.error("---------------");
        List<DaySpan> twoDayWindow = navigator.getPrecedingDayWindowList(span);
        logger.error("[Preceding] Window Day Span={}", (Object)span);
        for (DaySpan daySpan : twoDayWindow) {
            logger.error("Window Start Date={}, Index={}", (Object)daySpan.getDate(), (Object)daySpan.getIndex());
            for (Day day : daySpan.getList()) {
                logger.error("Day Start Date={}, Index={}, line count={}", day.getDate(), day.getIndex(), day.getLineItemList().size());
                for (LineItemInternal line : day.getLineItemList()) {
                    logger.error("Line {}", (Object)line.getDay().getLineIndex(line));
                }
            }
        }
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        Navigator navigator = processor.getResourceManager().getNavigator();
        try {
            this.runPrecedingWindowTest(navigator, -1);
        }
        catch (IllegalArgumentException e) {
            logger.error("Method runPrecedingWindowTest threw IAE with span of {}", (Object)-1);
        }
        try {
            this.runFollowingWindowTest(navigator, -1);
        }
        catch (IllegalArgumentException e) {
            logger.error("Method runFollowingWindowTest threw IAE with span of {}", (Object)-1);
        }
        try {
            this.runPrecedingWindowTest(navigator, 0);
        }
        catch (IllegalArgumentException e) {
            logger.error("Method runPrecedingWindowTest threw IAE with span of {}", (Object)0);
        }
        try {
            this.runFollowingWindowTest(navigator, 0);
        }
        catch (IllegalArgumentException e) {
            logger.error("Method runFollowingWindowTest threw IAE with span of {}", (Object)0);
        }
        this.runPrecedingWindowTest(navigator, 1);
        this.runFollowingWindowTest(navigator, 1);
        this.runPrecedingWindowTest(navigator, navigator.getDayCount());
        this.runFollowingWindowTest(navigator, navigator.getDayCount());
        this.runPrecedingWindowTest(navigator, navigator.getDayCount() + 1);
        this.runFollowingWindowTest(navigator, navigator.getDayCount() + 1);
        this.runPrecedingWindowTest(navigator, 500);
        this.runFollowingWindowTest(navigator, 500);
        return false;
    }
}

