/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.OpenApiApplicationConfiguration;
import gov.cms.fiss.pricers.common.application.PricerYearReference;
import gov.cms.fiss.pricers.common.application.Reporting;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PricerDispatch<I, O, C extends OpenApiApplicationConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PricerDispatch.class);
    protected final PricerYearReference<I, O> yearReference = new PricerYearReference();
    private final Function<O, String> failureCodeExtractor;

    protected PricerDispatch(C pricerConfiguration, Function<O, String> failureCodeExtractor) {
        this.failureCodeExtractor = failureCodeExtractor;
        this.initializeReferences(pricerConfiguration);
    }

    protected abstract void initializeReferences(C var1);

    protected abstract ClaimProcessor<I, O> getProcessor(I var1) throws YearNotImplementedException, InternalPricerException;

    protected abstract boolean isErrorOutput(O var1);

    public O process(I input) throws YearNotImplementedException, InternalPricerException {
        ClaimProcessor<I, O> claimProcessor = this.getProcessor(input);
        O output = claimProcessor.priceClaim(input);
        if (this.isErrorOutput(output)) {
            String errorCode = this.failureCodeExtractor.apply(output);
            LOGGER.debug("Claim processing did not complete successfully; return code: {}", (Object)errorCode);
            Reporting.reportEventToNR("FailedSubmission", "failureCode", errorCode);
        }
        return output;
    }
}

