/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDiagnosisRelatedGroup;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Schema(description="The IPF claim data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-IN-DATA", value="<structure>")})})
public class IpfClaimData
extends ClaimData {
    @BigDecimalScale
    @NotNull
    @Schema(description="The charges covered.", example="1234.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-CHARGES-CLAIMED", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal coveredCharges;
    @ArraySchema(arraySchema=@Schema(description="The diagnosis codes related to this claim.", example="[ \"B101\", \"K909\", \"G392\", \"B324\" ]"), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-OTHER-DIAG-DATA", value="PIC X(175)")})})
    @Size(max=25, min=1)
    private @Size(max=25, min=1) List<@Pattern(regexp="[A-Z\\d]{1,7}", message="must be seven or fewer alphanumeric characters") String> diagnosisCodes;
    @Schema(description="The diagnosis-related group.", example="001", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-DRG", value="PIC 9(03)")})})
    @ValidDiagnosisRelatedGroup
    private String diagnosisRelatedGroup;
    @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character")
    @Schema(description="The diagnosis-related group severity.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-DRG-SEVERITY", value="PIC X")})})
    private @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character") String diagnosisRelatedGroupSeverity;
    @NotNull
    @Schema(description="The discharge date.", example="2020-10-30", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-DISCHARGE-DATE", value="| D-CC PIC 9(02) D-YY PIC 9(02) D-MM PIC 9(02) D-DD PIC 9(02)")})})
    @StrictLocalDate
    private LocalDate dischargeDate;
    @Max(value=99999L)
    @Min(value=0L)
    @Schema(description="The length of stay.", example="60", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-LOS", value="PIC 9(05)")})})
    private @Max(value=99999L) @Min(value=0L) int lengthOfStay;
    @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character")
    @Schema(description="The outlier occurrence indicator.", example="Y", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-OUTL-OCCUR-IND", value="PIC X(01)")})})
    private @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character") String outlierOccurrenceIndicator;
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The patient's age.", example="32", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-AGE", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int patientAge;
    @NotNull
    @Pattern(regexp="\\d{2}", message="must be 2 digits")
    @Schema(description="The patient status.", example="01", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-PATIENT-STATUS", value="PIC X(02)")})})
    private @NotNull @Pattern(regexp="\\d{2}", message="must be 2 digits") String patientStatus;
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The prior days.", example="15", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-PRIOR-DAYS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int priorDays;
    @ArraySchema(arraySchema=@Schema(description="The procedure codes related to this claim.", example="[\"G40\", \"J99\", \"F21\", \"B42\"]"), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-OTHER-PROC-DATA", value="PIC X(175)")})})
    @NotNull
    @Size(max=25)
    private @NotNull @Size(max=25) List<@Pattern(regexp="[A-Z\\d]{1,7}", message="must be seven or fewer alphanumeric characters") String> procedureCodes = new ArrayList<String>();
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The number of electro-convulsive therapy (ECT) units.", example="15", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-ECT-NO-OF-UNITS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int serviceUnits;
    @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character")
    @Schema(description="The admission source.", example="D", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-SRC-OF-ADMISSION", value="PIC X(01)")})})
    private @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character") String sourceOfAdmission;

    @Generated
    public BigDecimal getCoveredCharges() {
        return this.coveredCharges;
    }

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{1,7}", message="must be seven or fewer alphanumeric characters") String> getDiagnosisCodes() {
        return this.diagnosisCodes;
    }

    @Generated
    public String getDiagnosisRelatedGroup() {
        return this.diagnosisRelatedGroup;
    }

    @Generated
    public String getDiagnosisRelatedGroupSeverity() {
        return this.diagnosisRelatedGroupSeverity;
    }

    @Generated
    public LocalDate getDischargeDate() {
        return this.dischargeDate;
    }

    @Generated
    public int getLengthOfStay() {
        return this.lengthOfStay;
    }

    @Generated
    public String getOutlierOccurrenceIndicator() {
        return this.outlierOccurrenceIndicator;
    }

    @Generated
    public int getPatientAge() {
        return this.patientAge;
    }

    @Generated
    public String getPatientStatus() {
        return this.patientStatus;
    }

    @Generated
    public int getPriorDays() {
        return this.priorDays;
    }

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{1,7}", message="must be seven or fewer alphanumeric characters") String> getProcedureCodes() {
        return this.procedureCodes;
    }

    @Generated
    public int getServiceUnits() {
        return this.serviceUnits;
    }

    @Generated
    public String getSourceOfAdmission() {
        return this.sourceOfAdmission;
    }

    @Generated
    public void setCoveredCharges(BigDecimal coveredCharges) {
        this.coveredCharges = coveredCharges;
    }

    @Generated
    public void setDiagnosisCodes(List<@Pattern(regexp="[A-Z\\d]{1,7}", message="must be seven or fewer alphanumeric characters") String> diagnosisCodes) {
        this.diagnosisCodes = diagnosisCodes;
    }

    @Generated
    public void setDiagnosisRelatedGroup(String diagnosisRelatedGroup) {
        this.diagnosisRelatedGroup = diagnosisRelatedGroup;
    }

    @Generated
    public void setDiagnosisRelatedGroupSeverity(String diagnosisRelatedGroupSeverity) {
        this.diagnosisRelatedGroupSeverity = diagnosisRelatedGroupSeverity;
    }

    @Generated
    public void setDischargeDate(LocalDate dischargeDate) {
        this.dischargeDate = dischargeDate;
    }

    @Generated
    public void setLengthOfStay(int lengthOfStay) {
        this.lengthOfStay = lengthOfStay;
    }

    @Generated
    public void setOutlierOccurrenceIndicator(String outlierOccurrenceIndicator) {
        this.outlierOccurrenceIndicator = outlierOccurrenceIndicator;
    }

    @Generated
    public void setPatientAge(int patientAge) {
        this.patientAge = patientAge;
    }

    @Generated
    public void setPatientStatus(String patientStatus) {
        this.patientStatus = patientStatus;
    }

    @Generated
    public void setPriorDays(int priorDays) {
        this.priorDays = priorDays;
    }

    @Generated
    public void setProcedureCodes(List<@Pattern(regexp="[A-Z\\d]{1,7}", message="must be seven or fewer alphanumeric characters") String> procedureCodes) {
        this.procedureCodes = procedureCodes;
    }

    @Generated
    public void setServiceUnits(int serviceUnits) {
        this.serviceUnits = serviceUnits;
    }

    @Generated
    public void setSourceOfAdmission(String sourceOfAdmission) {
        this.sourceOfAdmission = sourceOfAdmission;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IpfClaimData)) {
            return false;
        }
        IpfClaimData other = (IpfClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getLengthOfStay() != other.getLengthOfStay()) {
            return false;
        }
        if (this.getPatientAge() != other.getPatientAge()) {
            return false;
        }
        if (this.getPriorDays() != other.getPriorDays()) {
            return false;
        }
        if (this.getServiceUnits() != other.getServiceUnits()) {
            return false;
        }
        BigDecimal this$coveredCharges = this.getCoveredCharges();
        BigDecimal other$coveredCharges = other.getCoveredCharges();
        if (this$coveredCharges == null ? other$coveredCharges != null : !((Object)this$coveredCharges).equals(other$coveredCharges)) {
            return false;
        }
        List<String> this$diagnosisCodes = this.getDiagnosisCodes();
        List<String> other$diagnosisCodes = other.getDiagnosisCodes();
        if (this$diagnosisCodes == null ? other$diagnosisCodes != null : !((Object)this$diagnosisCodes).equals(other$diagnosisCodes)) {
            return false;
        }
        String this$diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
        String other$diagnosisRelatedGroup = other.getDiagnosisRelatedGroup();
        if (this$diagnosisRelatedGroup == null ? other$diagnosisRelatedGroup != null : !this$diagnosisRelatedGroup.equals(other$diagnosisRelatedGroup)) {
            return false;
        }
        String this$diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
        String other$diagnosisRelatedGroupSeverity = other.getDiagnosisRelatedGroupSeverity();
        if (this$diagnosisRelatedGroupSeverity == null ? other$diagnosisRelatedGroupSeverity != null : !this$diagnosisRelatedGroupSeverity.equals(other$diagnosisRelatedGroupSeverity)) {
            return false;
        }
        LocalDate this$dischargeDate = this.getDischargeDate();
        LocalDate other$dischargeDate = other.getDischargeDate();
        if (this$dischargeDate == null ? other$dischargeDate != null : !((Object)this$dischargeDate).equals(other$dischargeDate)) {
            return false;
        }
        String this$outlierOccurrenceIndicator = this.getOutlierOccurrenceIndicator();
        String other$outlierOccurrenceIndicator = other.getOutlierOccurrenceIndicator();
        if (this$outlierOccurrenceIndicator == null ? other$outlierOccurrenceIndicator != null : !this$outlierOccurrenceIndicator.equals(other$outlierOccurrenceIndicator)) {
            return false;
        }
        String this$patientStatus = this.getPatientStatus();
        String other$patientStatus = other.getPatientStatus();
        if (this$patientStatus == null ? other$patientStatus != null : !this$patientStatus.equals(other$patientStatus)) {
            return false;
        }
        List<String> this$procedureCodes = this.getProcedureCodes();
        List<String> other$procedureCodes = other.getProcedureCodes();
        if (this$procedureCodes == null ? other$procedureCodes != null : !((Object)this$procedureCodes).equals(other$procedureCodes)) {
            return false;
        }
        String this$sourceOfAdmission = this.getSourceOfAdmission();
        String other$sourceOfAdmission = other.getSourceOfAdmission();
        return !(this$sourceOfAdmission == null ? other$sourceOfAdmission != null : !this$sourceOfAdmission.equals(other$sourceOfAdmission));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IpfClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLengthOfStay();
        result = result * 59 + this.getPatientAge();
        result = result * 59 + this.getPriorDays();
        result = result * 59 + this.getServiceUnits();
        BigDecimal $coveredCharges = this.getCoveredCharges();
        result = result * 59 + ($coveredCharges == null ? 43 : ((Object)$coveredCharges).hashCode());
        List<String> $diagnosisCodes = this.getDiagnosisCodes();
        result = result * 59 + ($diagnosisCodes == null ? 43 : ((Object)$diagnosisCodes).hashCode());
        String $diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
        result = result * 59 + ($diagnosisRelatedGroup == null ? 43 : $diagnosisRelatedGroup.hashCode());
        String $diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
        result = result * 59 + ($diagnosisRelatedGroupSeverity == null ? 43 : $diagnosisRelatedGroupSeverity.hashCode());
        LocalDate $dischargeDate = this.getDischargeDate();
        result = result * 59 + ($dischargeDate == null ? 43 : ((Object)$dischargeDate).hashCode());
        String $outlierOccurrenceIndicator = this.getOutlierOccurrenceIndicator();
        result = result * 59 + ($outlierOccurrenceIndicator == null ? 43 : $outlierOccurrenceIndicator.hashCode());
        String $patientStatus = this.getPatientStatus();
        result = result * 59 + ($patientStatus == null ? 43 : $patientStatus.hashCode());
        List<String> $procedureCodes = this.getProcedureCodes();
        result = result * 59 + ($procedureCodes == null ? 43 : ((Object)$procedureCodes).hashCode());
        String $sourceOfAdmission = this.getSourceOfAdmission();
        result = result * 59 + ($sourceOfAdmission == null ? 43 : $sourceOfAdmission.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IpfClaimData(coveredCharges=" + this.getCoveredCharges() + ", diagnosisCodes=" + this.getDiagnosisCodes() + ", diagnosisRelatedGroup=" + this.getDiagnosisRelatedGroup() + ", diagnosisRelatedGroupSeverity=" + this.getDiagnosisRelatedGroupSeverity() + ", dischargeDate=" + this.getDischargeDate() + ", lengthOfStay=" + this.getLengthOfStay() + ", outlierOccurrenceIndicator=" + this.getOutlierOccurrenceIndicator() + ", patientAge=" + this.getPatientAge() + ", patientStatus=" + this.getPatientStatus() + ", priorDays=" + this.getPriorDays() + ", procedureCodes=" + this.getProcedureCodes() + ", serviceUnits=" + this.getServiceUnits() + ", sourceOfAdmission=" + this.getSourceOfAdmission() + ")";
    }

    @Generated
    public IpfClaimData() {
    }
}

