/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithThreeFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.ipf.api.v2.AdditionalVariableData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="The IPF prospective payment data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-DATA-VARIABLES", value="<structure>")})})
public class IpfPaymentData
extends PaymentData {
    @NotNull
    @Schema(description="The IPF additional variables for the payment data.")
    @Valid
    private AdditionalVariableData additionalVariables = new AdditionalVariableData();
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The age adjustment percent.", example="1.02", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-AGE-ADJ", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal ageAdjustmentPercent;
    @BigDecimalScale(scale=5)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99999")
    @Digits(integer=1, fraction=5)
    @Schema(description="The comorbidity factor.", example="1.12345", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-COMORB-FACTOR", value="PIC 9(01)V9(05)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99999") @Digits(integer=1, fraction=5) @FixedValue BigDecimal comorbidityFactor;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The cost-of-living adjustment percent.", example="1.111", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-COLA", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal costOfLivingAdjustmentPercent;
    @BigDecimalScale(scale=3)
    @Schema(description="The cost-to-charge ratio.", example="1.561", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-CSTCHG-RATIO", value="PIC 9(01)V9(03)")})})
    @ValidDecimalOutputWithThreeFractionDigits
    private BigDecimal costToChargeRatio;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The diagnosis-related group (DRG) factor.", example="2.33", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-DRG-FACTOR", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal diagnosisRelatedGroupFactor;
    @BigDecimalScale
    @DecimalMax(value="9.99")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=2)
    @Schema(description="The emergency adjustment percent.", example="6.83", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-EMERG-ADJ", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMax(value="9.99") @DecimalMin(value="0") @Digits(integer=1, fraction=2) @FixedValue BigDecimal emergencyAdjustmentPercent;
    @BigDecimalScale(scale=5)
    @DecimalMax(value="1.00000")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=5)
    @Schema(description="The national labor share percent.", example="0.61022", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-LABOR-SHARE", value="PIC 9(01)V9(05)")})})
    @FixedValue
    private @DecimalMax(value="1.00000") @DecimalMin(value="0") @Digits(integer=1, fraction=5) @FixedValue BigDecimal nationalLaborSharePercent;
    @BigDecimalScale(scale=5)
    @DecimalMax(value="1.00000")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=5)
    @Schema(description="The national non-labor share percent.", example="0.46205", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-NLABOR-SHARE", value="PIC 9(01)V9(05)")})})
    @FixedValue
    private @DecimalMax(value="1.00000") @DecimalMin(value="0") @Digits(integer=1, fraction=5) @FixedValue BigDecimal nationalNonLaborSharePercent;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The rural adjustment percent.", example="5.48", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPC-GEO-RURAL-ADJ", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal ruralAdjustmentPercent;
    @BigDecimalScale
    @Schema(description="The teaching adjustment percent.", example="1.17", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-TEACH-ADJ", value="PIC 9(01)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal teachingAdjustmentPercent;

    @Generated
    public AdditionalVariableData getAdditionalVariables() {
        return this.additionalVariables;
    }

    @Generated
    public BigDecimal getAgeAdjustmentPercent() {
        return this.ageAdjustmentPercent;
    }

    @Generated
    public BigDecimal getComorbidityFactor() {
        return this.comorbidityFactor;
    }

    @Generated
    public BigDecimal getCostOfLivingAdjustmentPercent() {
        return this.costOfLivingAdjustmentPercent;
    }

    @Generated
    public BigDecimal getCostToChargeRatio() {
        return this.costToChargeRatio;
    }

    @Generated
    public BigDecimal getDiagnosisRelatedGroupFactor() {
        return this.diagnosisRelatedGroupFactor;
    }

    @Generated
    public BigDecimal getEmergencyAdjustmentPercent() {
        return this.emergencyAdjustmentPercent;
    }

    @Generated
    public BigDecimal getNationalLaborSharePercent() {
        return this.nationalLaborSharePercent;
    }

    @Generated
    public BigDecimal getNationalNonLaborSharePercent() {
        return this.nationalNonLaborSharePercent;
    }

    @Generated
    public BigDecimal getRuralAdjustmentPercent() {
        return this.ruralAdjustmentPercent;
    }

    @Generated
    public BigDecimal getTeachingAdjustmentPercent() {
        return this.teachingAdjustmentPercent;
    }

    @Generated
    public void setAdditionalVariables(AdditionalVariableData additionalVariables) {
        this.additionalVariables = additionalVariables;
    }

    @Generated
    public void setAgeAdjustmentPercent(BigDecimal ageAdjustmentPercent) {
        this.ageAdjustmentPercent = ageAdjustmentPercent;
    }

    @Generated
    public void setComorbidityFactor(BigDecimal comorbidityFactor) {
        this.comorbidityFactor = comorbidityFactor;
    }

    @Generated
    public void setCostOfLivingAdjustmentPercent(BigDecimal costOfLivingAdjustmentPercent) {
        this.costOfLivingAdjustmentPercent = costOfLivingAdjustmentPercent;
    }

    @Generated
    public void setCostToChargeRatio(BigDecimal costToChargeRatio) {
        this.costToChargeRatio = costToChargeRatio;
    }

    @Generated
    public void setDiagnosisRelatedGroupFactor(BigDecimal diagnosisRelatedGroupFactor) {
        this.diagnosisRelatedGroupFactor = diagnosisRelatedGroupFactor;
    }

    @Generated
    public void setEmergencyAdjustmentPercent(BigDecimal emergencyAdjustmentPercent) {
        this.emergencyAdjustmentPercent = emergencyAdjustmentPercent;
    }

    @Generated
    public void setNationalLaborSharePercent(BigDecimal nationalLaborSharePercent) {
        this.nationalLaborSharePercent = nationalLaborSharePercent;
    }

    @Generated
    public void setNationalNonLaborSharePercent(BigDecimal nationalNonLaborSharePercent) {
        this.nationalNonLaborSharePercent = nationalNonLaborSharePercent;
    }

    @Generated
    public void setRuralAdjustmentPercent(BigDecimal ruralAdjustmentPercent) {
        this.ruralAdjustmentPercent = ruralAdjustmentPercent;
    }

    @Generated
    public void setTeachingAdjustmentPercent(BigDecimal teachingAdjustmentPercent) {
        this.teachingAdjustmentPercent = teachingAdjustmentPercent;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IpfPaymentData)) {
            return false;
        }
        IpfPaymentData other = (IpfPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdditionalVariableData this$additionalVariables = this.getAdditionalVariables();
        AdditionalVariableData other$additionalVariables = other.getAdditionalVariables();
        if (this$additionalVariables == null ? other$additionalVariables != null : !((Object)this$additionalVariables).equals(other$additionalVariables)) {
            return false;
        }
        BigDecimal this$ageAdjustmentPercent = this.getAgeAdjustmentPercent();
        BigDecimal other$ageAdjustmentPercent = other.getAgeAdjustmentPercent();
        if (this$ageAdjustmentPercent == null ? other$ageAdjustmentPercent != null : !((Object)this$ageAdjustmentPercent).equals(other$ageAdjustmentPercent)) {
            return false;
        }
        BigDecimal this$comorbidityFactor = this.getComorbidityFactor();
        BigDecimal other$comorbidityFactor = other.getComorbidityFactor();
        if (this$comorbidityFactor == null ? other$comorbidityFactor != null : !((Object)this$comorbidityFactor).equals(other$comorbidityFactor)) {
            return false;
        }
        BigDecimal this$costOfLivingAdjustmentPercent = this.getCostOfLivingAdjustmentPercent();
        BigDecimal other$costOfLivingAdjustmentPercent = other.getCostOfLivingAdjustmentPercent();
        if (this$costOfLivingAdjustmentPercent == null ? other$costOfLivingAdjustmentPercent != null : !((Object)this$costOfLivingAdjustmentPercent).equals(other$costOfLivingAdjustmentPercent)) {
            return false;
        }
        BigDecimal this$costToChargeRatio = this.getCostToChargeRatio();
        BigDecimal other$costToChargeRatio = other.getCostToChargeRatio();
        if (this$costToChargeRatio == null ? other$costToChargeRatio != null : !((Object)this$costToChargeRatio).equals(other$costToChargeRatio)) {
            return false;
        }
        BigDecimal this$diagnosisRelatedGroupFactor = this.getDiagnosisRelatedGroupFactor();
        BigDecimal other$diagnosisRelatedGroupFactor = other.getDiagnosisRelatedGroupFactor();
        if (this$diagnosisRelatedGroupFactor == null ? other$diagnosisRelatedGroupFactor != null : !((Object)this$diagnosisRelatedGroupFactor).equals(other$diagnosisRelatedGroupFactor)) {
            return false;
        }
        BigDecimal this$emergencyAdjustmentPercent = this.getEmergencyAdjustmentPercent();
        BigDecimal other$emergencyAdjustmentPercent = other.getEmergencyAdjustmentPercent();
        if (this$emergencyAdjustmentPercent == null ? other$emergencyAdjustmentPercent != null : !((Object)this$emergencyAdjustmentPercent).equals(other$emergencyAdjustmentPercent)) {
            return false;
        }
        BigDecimal this$nationalLaborSharePercent = this.getNationalLaborSharePercent();
        BigDecimal other$nationalLaborSharePercent = other.getNationalLaborSharePercent();
        if (this$nationalLaborSharePercent == null ? other$nationalLaborSharePercent != null : !((Object)this$nationalLaborSharePercent).equals(other$nationalLaborSharePercent)) {
            return false;
        }
        BigDecimal this$nationalNonLaborSharePercent = this.getNationalNonLaborSharePercent();
        BigDecimal other$nationalNonLaborSharePercent = other.getNationalNonLaborSharePercent();
        if (this$nationalNonLaborSharePercent == null ? other$nationalNonLaborSharePercent != null : !((Object)this$nationalNonLaborSharePercent).equals(other$nationalNonLaborSharePercent)) {
            return false;
        }
        BigDecimal this$ruralAdjustmentPercent = this.getRuralAdjustmentPercent();
        BigDecimal other$ruralAdjustmentPercent = other.getRuralAdjustmentPercent();
        if (this$ruralAdjustmentPercent == null ? other$ruralAdjustmentPercent != null : !((Object)this$ruralAdjustmentPercent).equals(other$ruralAdjustmentPercent)) {
            return false;
        }
        BigDecimal this$teachingAdjustmentPercent = this.getTeachingAdjustmentPercent();
        BigDecimal other$teachingAdjustmentPercent = other.getTeachingAdjustmentPercent();
        return !(this$teachingAdjustmentPercent == null ? other$teachingAdjustmentPercent != null : !((Object)this$teachingAdjustmentPercent).equals(other$teachingAdjustmentPercent));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IpfPaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AdditionalVariableData $additionalVariables = this.getAdditionalVariables();
        result = result * 59 + ($additionalVariables == null ? 43 : ((Object)$additionalVariables).hashCode());
        BigDecimal $ageAdjustmentPercent = this.getAgeAdjustmentPercent();
        result = result * 59 + ($ageAdjustmentPercent == null ? 43 : ((Object)$ageAdjustmentPercent).hashCode());
        BigDecimal $comorbidityFactor = this.getComorbidityFactor();
        result = result * 59 + ($comorbidityFactor == null ? 43 : ((Object)$comorbidityFactor).hashCode());
        BigDecimal $costOfLivingAdjustmentPercent = this.getCostOfLivingAdjustmentPercent();
        result = result * 59 + ($costOfLivingAdjustmentPercent == null ? 43 : ((Object)$costOfLivingAdjustmentPercent).hashCode());
        BigDecimal $costToChargeRatio = this.getCostToChargeRatio();
        result = result * 59 + ($costToChargeRatio == null ? 43 : ((Object)$costToChargeRatio).hashCode());
        BigDecimal $diagnosisRelatedGroupFactor = this.getDiagnosisRelatedGroupFactor();
        result = result * 59 + ($diagnosisRelatedGroupFactor == null ? 43 : ((Object)$diagnosisRelatedGroupFactor).hashCode());
        BigDecimal $emergencyAdjustmentPercent = this.getEmergencyAdjustmentPercent();
        result = result * 59 + ($emergencyAdjustmentPercent == null ? 43 : ((Object)$emergencyAdjustmentPercent).hashCode());
        BigDecimal $nationalLaborSharePercent = this.getNationalLaborSharePercent();
        result = result * 59 + ($nationalLaborSharePercent == null ? 43 : ((Object)$nationalLaborSharePercent).hashCode());
        BigDecimal $nationalNonLaborSharePercent = this.getNationalNonLaborSharePercent();
        result = result * 59 + ($nationalNonLaborSharePercent == null ? 43 : ((Object)$nationalNonLaborSharePercent).hashCode());
        BigDecimal $ruralAdjustmentPercent = this.getRuralAdjustmentPercent();
        result = result * 59 + ($ruralAdjustmentPercent == null ? 43 : ((Object)$ruralAdjustmentPercent).hashCode());
        BigDecimal $teachingAdjustmentPercent = this.getTeachingAdjustmentPercent();
        result = result * 59 + ($teachingAdjustmentPercent == null ? 43 : ((Object)$teachingAdjustmentPercent).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IpfPaymentData(additionalVariables=" + this.getAdditionalVariables() + ", ageAdjustmentPercent=" + this.getAgeAdjustmentPercent() + ", comorbidityFactor=" + this.getComorbidityFactor() + ", costOfLivingAdjustmentPercent=" + this.getCostOfLivingAdjustmentPercent() + ", costToChargeRatio=" + this.getCostToChargeRatio() + ", diagnosisRelatedGroupFactor=" + this.getDiagnosisRelatedGroupFactor() + ", emergencyAdjustmentPercent=" + this.getEmergencyAdjustmentPercent() + ", nationalLaborSharePercent=" + this.getNationalLaborSharePercent() + ", nationalNonLaborSharePercent=" + this.getNationalNonLaborSharePercent() + ", ruralAdjustmentPercent=" + this.getRuralAdjustmentPercent() + ", teachingAdjustmentPercent=" + this.getTeachingAdjustmentPercent() + ")";
    }

    @Generated
    public IpfPaymentData() {
    }
}

