/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.PricerDispatch;
import gov.cms.fiss.pricers.ipf.IpfPricerConfiguration;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.Ipf2020RulePricer;
import gov.cms.fiss.pricers.ipf.core.Ipf2021RulePricer;
import gov.cms.fiss.pricers.ipf.core.Ipf2022RulePricer;
import gov.cms.fiss.pricers.ipf.core.Ipf2023RulePricer;
import gov.cms.fiss.pricers.ipf.core.Ipf2024RulePricer;
import gov.cms.fiss.pricers.ipf.core.Ipf2025RulePricer;
import gov.cms.fiss.pricers.ipf.core.Ipf2026RulePricer;
import gov.cms.fiss.pricers.ipf.core.tables.DataTables;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpfPricerDispatch
extends PricerDispatch<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(IpfPricerDispatch.class);

    public IpfPricerDispatch(IpfPricerConfiguration configuration) {
        super(configuration, o -> o.getReturnCodeData().getCode());
    }

    @Override
    protected void initializeReferences(IpfPricerConfiguration pricerConfiguration) {
        DataTables.loadDataTables(pricerConfiguration);
        for (int supportedYear : pricerConfiguration.getSupportedYears()) {
            switch (supportedYear) {
                case 2020: {
                    this.yearReference.register(supportedYear, Ipf2020RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2021: {
                    this.yearReference.register(supportedYear, Ipf2021RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2022: {
                    this.yearReference.register(supportedYear, Ipf2022RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2023: {
                    this.yearReference.register(supportedYear, Ipf2023RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2024: {
                    this.yearReference.register(supportedYear, Ipf2024RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2025: {
                    this.yearReference.register(supportedYear, Ipf2025RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2026: {
                    this.yearReference.register(supportedYear, Ipf2026RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
            }
        }
    }

    @Override
    protected ClaimProcessor<IpfClaimPricingRequest, IpfClaimPricingResponse> getProcessor(IpfClaimPricingRequest input) throws YearNotImplementedException, InternalPricerException {
        return this.yearReference.fromFiscalYear(((IpfClaimData)input.getClaimData()).getDischargeDate(), "dischargeDate");
    }

    @Override
    protected boolean isErrorOutput(IpfClaimPricingResponse output) {
        return Integer.parseInt(output.getReturnCodeData().getCode()) >= 50;
    }
}

