/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.assemble_pps_variables;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.api.v2.IpfPaymentData;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.tables.CodeFirstTableEntry;
import java.math.BigDecimal;
import java.util.List;

public class GetFirstCodes
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public boolean shouldExecute(IpfPricerContext calculationContext) {
        return calculationContext.getPaymentData().getDiagnosisRelatedGroupFactor() == null;
    }

    @Override
    public void calculate(IpfPricerContext calculationContext) {
        IpfPaymentData paymentData = calculationContext.getPaymentData();
        CodeFirstTableEntry entry = null;
        List<String> diagnosticCodes = calculationContext.getDiagnosisCodes();
        if (diagnosticCodes.size() > 1) {
            entry = calculationContext.getDataTables().getCodeFirstEntry(diagnosticCodes.get(1));
        }
        if (entry != null) {
            paymentData.setDiagnosisRelatedGroupFactor(entry.getFactor());
        } else {
            paymentData.setDiagnosisRelatedGroupFactor(new BigDecimal("1.00"));
        }
    }
}

