/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.common;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.common.AbstractOutputStreamAppenderFactory;
import io.dropwizard.logging.common.socket.DropwizardSocketAppender;
import io.dropwizard.util.DataSize;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDataSize;
import io.dropwizard.validation.PortRange;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import javax.net.SocketFactory;

@JsonTypeName(value="tcp")
public class TcpSocketAppenderFactory<E extends DeferredProcessingAware>
extends AbstractOutputStreamAppenderFactory<E> {
    @NotEmpty
    private String host = "localhost";
    @PortRange
    private int port = 4560;
    @NotNull
    private Duration connectionTimeout = Duration.milliseconds(500L);
    private boolean immediateFlush = true;
    @MinDataSize(value=1L)
    private @MinDataSize(value=1L) DataSize sendBufferSize = DataSize.kibibytes(8L);

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @JsonProperty
    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @JsonProperty
    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    @JsonProperty
    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    @JsonProperty
    public DataSize getSendBufferSize() {
        return this.sendBufferSize;
    }

    @JsonProperty
    public void setSendBufferSize(DataSize sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    @Override
    protected OutputStreamAppender<E> appender(LoggerContext context) {
        DropwizardSocketAppender appender = new DropwizardSocketAppender(this.host, this.port, (int)this.connectionTimeout.toMilliseconds(), (int)this.sendBufferSize.toBytes(), this.socketFactory());
        appender.setContext(context);
        appender.setName("tcp-socket-appender");
        appender.setImmediateFlush(this.immediateFlush);
        return appender;
    }

    protected SocketFactory socketFactory() {
        return SocketFactory.getDefault();
    }
}

