/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.common;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.dropwizard.metrics.common.StringMatchingStrategy;
import java.time.Duration;
import java.util.Set;
import java.util.regex.Pattern;

class RegexStringMatchingStrategy
implements StringMatchingStrategy {
    private final LoadingCache<String, Pattern> patternCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofHours(1L)).build(Pattern::compile);

    RegexStringMatchingStrategy() {
    }

    @Override
    public boolean containsMatch(Set<String> matchExpressions, String metricName) {
        for (String regexExpression : matchExpressions) {
            Pattern pattern = this.patternCache.get(regexExpression);
            if (pattern == null || !pattern.matcher(metricName).matches()) continue;
            return true;
        }
        return false;
    }
}

