/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jaxb.internal;

import jakarta.inject.Inject;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import javax.xml.stream.XMLInputFactory;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.jaxb.internal.AbstractXmlFactory;
import org.glassfish.jersey.jaxb.internal.JaxbFeatureUtil;

public class XmlInputFactoryInjectionProvider
extends AbstractXmlFactory<XMLInputFactory> {
    private InjectionManager injectionManager;

    @Inject
    public XmlInputFactoryInjectionProvider(@Context InjectionManager injectionManager, @Context Configuration config) {
        super(config);
        this.injectionManager = injectionManager;
    }

    @Override
    public XMLInputFactory get() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        if (!this.isXmlSecurityDisabled()) {
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        }
        JaxbFeatureUtil.setProperties(this.injectionManager, XMLInputFactory.class, factory::setProperty);
        return factory;
    }
}

