/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.extension.PreInterruptCallbackInvocation;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.jupiter.engine.extension.TimeoutExceptionFactory;

class SeparateThreadTimeoutInvocation<T>
implements InvocationInterceptor.Invocation<T> {
    private final InvocationInterceptor.Invocation<T> delegate;
    private final TimeoutDuration timeout;
    private final Supplier<String> descriptionSupplier;
    private final PreInterruptCallbackInvocation preInterruptCallback;

    SeparateThreadTimeoutInvocation(InvocationInterceptor.Invocation<T> delegate, TimeoutDuration timeout, Supplier<String> descriptionSupplier, PreInterruptCallbackInvocation preInterruptCallback) {
        this.delegate = delegate;
        this.timeout = timeout;
        this.descriptionSupplier = descriptionSupplier;
        this.preInterruptCallback = preInterruptCallback;
    }

    @Override
    public T proceed() throws Throwable {
        return (T)Assertions.assertTimeoutPreemptively(this.timeout.toDuration(), this.delegate::proceed, this.descriptionSupplier, (__, messageSupplier, cause, testThread) -> {
            TimeoutException exception = TimeoutExceptionFactory.create((String)messageSupplier.get(), this.timeout, null);
            this.preInterruptCallback.executePreInterruptCallback(testThread, exception::addSuppressed);
            exception.initCause(cause);
            return exception;
        });
    }
}

