/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.errors;

import gov.cms.fiss.pricers.common.application.errors.AbstractStatusExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.BaseError;
import jakarta.ws.rs.core.Response;
import org.glassfish.jersey.server.ParamException;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;

public abstract class AbstractParamExceptionMapper<E extends ParamException>
extends AbstractStatusExceptionMapper<E> {
    private static final String ERROR_MESSAGE = "Invalid Request Parameter";
    private final String formatString;

    protected AbstractParamExceptionMapper(String formatString) {
        super(Response.Status.BAD_REQUEST, ERROR_MESSAGE);
        this.formatString = formatString;
    }

    @Override
    protected BaseError generateError(E exception) {
        return new BaseError(ERROR_MESSAGE, this.status.getStatusCode());
    }

    @Override
    protected Problem generateProblem(E exception) {
        ProblemBuilder problemBuilder = Problem.builder().withTitle(this.title).withStatus(Status.valueOf(this.status.getStatusCode())).withDetail(String.format(this.formatString, ((ParamException)exception).getParameterName()));
        return problemBuilder.build();
    }
}

