/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.filters;

import jakarta.annotation.Priority;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.math.NumberUtils;

@Priority(value=4000)
public class ContentLengthFilter
implements Filter {
    public static final int DEFAULT_MAXIMUM_REQUEST_SIZE = 102400;
    public static final String PROPERTY_MAX_REQUEST_SIZE = "maximumRequestSize";
    private int maximumRequestSize = 102400;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String maxRequestSizeConfig = filterConfig.getInitParameter(PROPERTY_MAX_REQUEST_SIZE);
        this.maximumRequestSize = NumberUtils.toInt(maxRequestSizeConfig, 102400);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int contentLength = request.getContentLength();
        if (contentLength <= this.maximumRequestSize) {
            chain.doFilter(request, response);
        } else {
            ((HttpServletResponse)response).sendError(413, String.format("Payload exceeds pricer limits: %s", contentLength));
        }
    }
}

