/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.ipf.IpfPricerConfiguration;
import gov.cms.fiss.pricers.ipf.core.IpfPricerDispatch;
import gov.cms.fiss.pricers.ipf.resources.IpfClaimPricingResource;
import gov.cms.fiss.pricers.ipf.resources.IpfExtractionUtil;
import io.dropwizard.core.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpfPricerApplication
extends OpenApiPricerApplication<IpfPricerConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(IpfPricerApplication.class);

    public static void main(String[] args) throws Exception {
        new IpfPricerApplication().run(args);
    }

    @Override
    protected void configureApplication(IpfPricerConfiguration configuration, Environment environment) {
        IpfClaimPricingResource v2Resource = new IpfClaimPricingResource(new IpfPricerDispatch(configuration));
        environment.jersey().register(v2Resource);
        environment.jersey().register(new CbsaWageIndexResource(configuration, IpfExtractionUtil.CBSA_EXTRACTOR));
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("IPF Pricer").version("v1")));
        return customizers;
    }

    @Override
    public String getName() {
        return "ipf-pricer";
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(IpfClaimPricingResource.class.getPackage());
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.of(2020, "2020.2", 2021, "2021.0", 2022, "2022.1", 2023, "2023.1", 2024, "2024.1", 2025, "2025.1", 2026, "2026.0");
    }
}

