/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipf.api.v2.AdditionalVariableData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.api.v2.IpfPaymentData;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateWageAdjustedRates
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        AdditionalVariableData additionalVariables = calculationContext.getAdditionalVariables();
        IpfPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal budgetRate = calculationContext.getAdditionalVariables().getBudgetRateAmount();
        BigDecimal laborBase = budgetRate.multiply(calculationContext.getLaborShare()).multiply(paymentData.getFinalWageIndex()).setScale(5, RoundingMode.HALF_UP);
        additionalVariables.setBaseLaborAmount(laborBase);
        BigDecimal nonLaborBase = budgetRate.multiply(calculationContext.getNonLaborShare()).multiply(paymentData.getCostOfLivingAdjustmentPercent()).setScale(5, RoundingMode.HALF_UP);
        additionalVariables.setBaseNonLaborAmount(nonLaborBase);
        additionalVariables.setWageAdjustedAmount(laborBase.add(nonLaborBase).setScale(2, RoundingMode.HALF_UP));
    }
}

