/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.calculate_payment.calculate_outlier;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipf.api.v2.AdditionalVariableData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.api.v2.IpfPaymentData;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateOutlierPerDiem
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        IpfClaimData claimData = calculationContext.getClaimData();
        AdditionalVariableData additionalVariables = calculationContext.getAdditionalVariables();
        IpfPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal outlierThreshold = BigDecimalUtils.defaultValue(additionalVariables.getOutlierThresholdAmount(), BigDecimal.ZERO);
        BigDecimal outlierLabor = outlierThreshold.multiply(calculationContext.getLaborShare()).multiply(calculationContext.getCbsaWageIndexEntry().getGeographicWageIndex()).setScale(5, RoundingMode.HALF_UP);
        additionalVariables.setOutlierBaseLaborAmount(outlierLabor);
        BigDecimal outlierNonLabor = outlierThreshold.multiply(calculationContext.getNonLaborShare()).multiply(paymentData.getCostOfLivingAdjustmentPercent()).setScale(5, RoundingMode.HALF_UP);
        additionalVariables.setOutlierBaseNonLaborAmount(outlierNonLabor);
        BigDecimal outlierThresholdAdjustedAmount = outlierLabor.add(outlierNonLabor).multiply(paymentData.getRuralAdjustmentPercent()).multiply(paymentData.getTeachingAdjustmentPercent()).add(additionalVariables.getFederalPayment()).add(additionalVariables.getElectroConvulsiveTherapyPayment()).setScale(2, RoundingMode.HALF_UP);
        additionalVariables.setOutlierThresholdAdjustedAmount(outlierThresholdAdjustedAmount);
        BigDecimal costToChargeRatio = calculationContext.getProviderData().getOperatingCostToChargeRatio();
        paymentData.setCostToChargeRatio(costToChargeRatio);
        BigDecimal outlierCost = claimData.getCoveredCharges().multiply(costToChargeRatio).setScale(2, RoundingMode.HALF_UP);
        additionalVariables.setOutlierCost(outlierCost);
        calculationContext.applyReturnCode(ReturnCode.OUTLIER_2);
        if (BigDecimalUtils.isLessThan(outlierCost, outlierThresholdAdjustedAmount)) {
            additionalVariables.setOutlierPayment(BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY));
            calculationContext.applyReturnCode(ReturnCode.NORMAL_PAYMENT_0);
            return;
        }
        BigDecimal outlierAdjustedCost = outlierCost.subtract(outlierThresholdAdjustedAmount).abs();
        additionalVariables.setOutlierAdjustedCost(outlierAdjustedCost);
        BigDecimal outlierPerDiem = outlierAdjustedCost.divide(new BigDecimal(claimData.getLengthOfStay()), 2, RoundingMode.HALF_UP);
        additionalVariables.setOutlierPerDiemAmount(outlierPerDiem);
    }
}

