/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.pre_processing;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.codes.ReturnCode;
import java.time.LocalDate;

public class ValidateDischargeDate
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        LocalDate effectiveDate;
        LocalDate dischargeDate = calculationContext.getClaimData().getDischargeDate();
        if (LocalDateUtils.isBefore(dischargeDate, effectiveDate = calculationContext.getProviderData().getEffectiveDate()) || LocalDateUtils.isBefore(effectiveDate, LocalDate.of(2006, 7, 1))) {
            calculationContext.completeWithReturnCode(ReturnCode.INVALID_DISCHARGE_DATE_55);
        }
    }
}

