/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.ipf.IpfPricerConfiguration;
import gov.cms.fiss.pricers.ipf.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ipf.core.tables.CbsaWageIndexLookupGenerator;
import gov.cms.fiss.pricers.ipf.core.tables.CodeFirstLookupGenerator;
import gov.cms.fiss.pricers.ipf.core.tables.CodeFirstTableEntry;
import gov.cms.fiss.pricers.ipf.core.tables.ComorbidityLookupGenerator;
import gov.cms.fiss.pricers.ipf.core.tables.ComorbidityTableEntry;
import gov.cms.fiss.pricers.ipf.core.tables.DrgLookupGenerator;
import gov.cms.fiss.pricers.ipf.core.tables.DrgTableEntry;
import gov.cms.fiss.pricers.ipf.core.tables.ProcedureLookupGenerator;
import gov.cms.fiss.pricers.ipf.core.tables.ProcedureTableEntry;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class DataTables {
    private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<Integer, DataTables>();
    private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
    private final Map<String, ComorbidityTableEntry> comorbidityEntryMap;
    private final Map<String, CodeFirstTableEntry> codeFirstEntryMap;
    private final Map<String, DrgTableEntry> drgEntryMap;
    private final Map<String, ProcedureTableEntry> procedureTableEntryMap;

    public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, ComorbidityTableEntry> comorbidityEntryMap, Map<String, CodeFirstTableEntry> codeFirstEntryMap, Map<String, DrgTableEntry> drgEntryMap, Map<String, ProcedureTableEntry> procedureTableEntryMap) {
        this.cbsaTable = cbsaTable;
        this.comorbidityEntryMap = comorbidityEntryMap;
        this.codeFirstEntryMap = codeFirstEntryMap;
        this.drgEntryMap = drgEntryMap;
        this.procedureTableEntryMap = procedureTableEntryMap;
    }

    public static DataTables forYear(int pricerYear) {
        return YEAR_LOOKUP.get(pricerYear);
    }

    public static void loadDataTables(IpfPricerConfiguration configuration) {
        CsvIngestionConfiguration csvIngestionConfiguration = configuration.getCsvIngestionConfiguration();
        for (int pricerYear : configuration.getSupportedYears()) {
            Map<String, ComorbidityTableEntry> comorbidityEntryMap = new ComorbidityLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
            Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaEntryMap = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
            Map<String, CodeFirstTableEntry> codeFirstEntryMap = new CodeFirstLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
            Map<String, DrgTableEntry> drgEntryMap = new DrgLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
            Map<String, ProcedureTableEntry> procedureTableEntryMap = new ProcedureLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
            YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaEntryMap, comorbidityEntryMap, codeFirstEntryMap, drgEntryMap, procedureTableEntryMap));
        }
    }

    public CbsaWageIndexEntry getCbsaWageIndexEntry(String code, LocalDate date) {
        NavigableMap<LocalDate, CbsaWageIndexEntry> map = this.cbsaTable.get(code.trim());
        if (map == null) {
            return null;
        }
        Map.Entry<LocalDate, CbsaWageIndexEntry> kvPair = map.floorEntry(date);
        if (kvPair == null) {
            return null;
        }
        return map.floorEntry(date).getValue();
    }

    public ComorbidityTableEntry getComorbidityTableEntry(String code) {
        ComorbidityTableEntry entry = this.comorbidityEntryMap.get(code);
        return null == entry ? null : entry;
    }

    public CodeFirstTableEntry getCodeFirstEntry(String code) {
        CodeFirstTableEntry entry = this.codeFirstEntryMap.get(code);
        return null == entry ? null : entry;
    }

    public DrgTableEntry getDrgEntry(String code) {
        DrgTableEntry entry = this.drgEntryMap.get(code);
        return null == entry ? null : entry;
    }

    public ProcedureTableEntry getProcedureTableEntry(String code) {
        return this.procedureTableEntryMap.get(code);
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
        return this.cbsaTable;
    }
}

