/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.health.HealthStateAggregator;
import io.dropwizard.health.HealthStateView;
import io.dropwizard.health.HealthStatusChecker;
import io.dropwizard.health.response.HealthResponse;
import io.dropwizard.health.response.HealthResponseProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHealthResponseProvider
implements HealthResponseProvider {
    public static final String CHECK_TYPE_QUERY_PARAM = "type";
    public static final String NAME_QUERY_PARAM = "name";
    public static final String ALL_VALUE = "all";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonHealthResponseProvider.class);
    private static final String MEDIA_TYPE = "application/json";
    private final @NonNull HealthStatusChecker healthStatusChecker;
    private final @NonNull HealthStateAggregator healthStateAggregator;
    private final @NonNull ObjectMapper mapper;

    public JsonHealthResponseProvider(@NonNull HealthStatusChecker healthStatusChecker, @NonNull HealthStateAggregator healthStateAggregator, @NonNull ObjectMapper mapper) {
        this.healthStatusChecker = Objects.requireNonNull(healthStatusChecker);
        this.healthStateAggregator = Objects.requireNonNull(healthStateAggregator);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public @NonNull HealthResponse healthResponse(Map<String, Collection<String>> queryParams) {
        String responseBody;
        String type = ((Collection)queryParams.getOrDefault(CHECK_TYPE_QUERY_PARAM, Collections.emptyList())).stream().findFirst().orElse(null);
        Collection<HealthStateView> views = this.getViews(queryParams);
        try {
            responseBody = this.mapper.writeValueAsString(views);
        }
        catch (Exception e) {
            LOGGER.error("Failed to serialize health state views: {}", (Object)views, (Object)e);
            throw new RuntimeException(e);
        }
        boolean healthy = this.healthStatusChecker.isHealthy(type);
        int status = healthy ? 200 : 503;
        return new HealthResponse(healthy, responseBody, MEDIA_TYPE, status);
    }

    private Set<String> getNamesFromQueryParams(Map<String, Collection<String>> queryParams) {
        return ((Collection)queryParams.getOrDefault(NAME_QUERY_PARAM, Collections.emptyList())).stream().map(String::toLowerCase).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Collection<HealthStateView> getViews(Map<String, Collection<String>> queryParams) {
        Set<String> names = this.getNamesFromQueryParams(queryParams);
        if (this.shouldReturnAllViews(names)) {
            return List.copyOf(this.healthStateAggregator.healthStateViews());
        }
        return names.stream().map(this.healthStateAggregator::healthStateView).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    private boolean shouldReturnAllViews(Set<String> names) {
        return names.contains(ALL_VALUE);
    }
}

