/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.innate.inject;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.client.innate.inject.NonInjectionManager;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.LazyUid;
import org.glassfish.jersey.process.internal.RequestContext;
import org.glassfish.jersey.process.internal.RequestScope;

public class NonInjectionRequestScope
extends RequestScope {
    private final NonInjectionManager nonInjectionManager;

    public NonInjectionRequestScope(NonInjectionManager nonInjectionManager) {
        this.nonInjectionManager = nonInjectionManager;
    }

    @Override
    public RequestContext createContext() {
        return new Instance(this.nonInjectionManager);
    }

    public static final class Instance
    implements RequestContext {
        private final NonInjectionManager injectionManager;
        private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(Instance.class.getName()), Level.FINEST);
        private final LazyUid id = new LazyUid();
        private int referenceCounter;

        private Instance(NonInjectionManager injectionManager) {
            this.injectionManager = injectionManager;
            this.referenceCounter = 1;
        }

        @Override
        public Instance getReference() {
            ++this.referenceCounter;
            return this;
        }

        @Override
        public void release() {
            if (0 == --this.referenceCounter) {
                this.injectionManager.disposeRequestScopedInstances();
            }
        }

        public String toString() {
            return "Instance{id=" + this.id + ", referenceCounter=" + this.referenceCounter + '}';
        }
    }
}

