/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.MediaType;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.platform.commons.util.Preconditions;

@FunctionalInterface
@API(status=API.Status.STABLE, since="5.0")
public interface TestReporter {
    public void publishEntry(Map<String, String> var1);

    default public void publishEntry(String key, String value) {
        this.publishEntry(Collections.singletonMap(key, value));
    }

    @API(status=API.Status.STABLE, since="5.3")
    default public void publishEntry(String value) {
        this.publishEntry("value", value);
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.12")
    default public void publishFile(Path file, MediaType mediaType) {
        Preconditions.condition(Files.exists(file, new LinkOption[0]), () -> "file must exist: " + file);
        Preconditions.condition(Files.isRegularFile(file, new LinkOption[0]), () -> "file must be a regular file: " + file);
        this.publishFile(file.getFileName().toString(), mediaType, path -> Files.copy(file, path, StandardCopyOption.REPLACE_EXISTING));
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.12")
    default public void publishDirectory(Path directory) {
        Preconditions.condition(Files.exists(directory, new LinkOption[0]), () -> "directory must exist: " + directory);
        Preconditions.condition(Files.isDirectory(directory, new LinkOption[0]), () -> "directory must be a directory: " + directory);
        this.publishDirectory(directory.getFileName().toString(), path -> {
            try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
                stream.forEach(source -> {
                    Path destination = path.resolve(directory.relativize((Path)source));
                    try {
                        if (Files.isDirectory(source, new LinkOption[0])) {
                            Files.createDirectories(destination, new FileAttribute[0]);
                        } else {
                            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to copy files to the output directory", e);
                    }
                });
            }
        });
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.12")
    default public void publishFile(String name, MediaType mediaType, ThrowingConsumer<Path> action) {
        throw new UnsupportedOperationException();
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.12")
    default public void publishDirectory(String name, ThrowingConsumer<Path> action) {
        throw new UnsupportedOperationException();
    }
}

