/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Exceptional;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.jackson.AbstractThrowableProblemMixIn;
import org.zalando.problem.jackson.ExceptionalMixin;
import org.zalando.problem.jackson.ExceptionalWithoutStacktraceMixin;
import org.zalando.problem.jackson.ProblemMixIn;
import org.zalando.problem.jackson.StatusTypeDeserializer;
import org.zalando.problem.jackson.StatusTypeSerializer;

@API(status=API.Status.STABLE)
public final class ProblemModule
extends Module {
    private final boolean stackTraces;
    private final Map<Integer, StatusType> statuses;

    public ProblemModule() {
        this(Status.class);
    }

    @SafeVarargs
    public <E extends Enum<?>> ProblemModule(Class<? extends E> ... types) throws IllegalArgumentException {
        this(false, ProblemModule.buildIndex(types));
    }

    private ProblemModule(boolean stackTraces, Map<Integer, StatusType> statuses) {
        this.stackTraces = stackTraces;
        this.statuses = statuses;
    }

    @Override
    public String getModuleName() {
        return ProblemModule.class.getSimpleName();
    }

    @Override
    public Version version() {
        return VersionUtil.mavenVersionFor(ProblemModule.class.getClassLoader(), "org.zalando", "jackson-datatype-problem");
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        SimpleModule module = new SimpleModule();
        module.setMixInAnnotation(Exceptional.class, this.stackTraces ? ExceptionalMixin.class : ExceptionalWithoutStacktraceMixin.class);
        module.setMixInAnnotation(DefaultProblem.class, AbstractThrowableProblemMixIn.class);
        module.setMixInAnnotation(Problem.class, ProblemMixIn.class);
        module.addSerializer(StatusType.class, new StatusTypeSerializer());
        module.addDeserializer(StatusType.class, new StatusTypeDeserializer(this.statuses));
        module.setupModule(context);
    }

    @SafeVarargs
    private static <E extends Enum<?>> Map<Integer, StatusType> buildIndex(Class<? extends E> ... types) {
        HashMap<Integer, Enum> index = new HashMap<Integer, Enum>();
        for (Class<E> clazz : types) {
            for (Enum status : (Enum[])clazz.getEnumConstants()) {
                if (index.containsKey(((StatusType)((Object)status)).getStatusCode())) {
                    throw new IllegalArgumentException("Duplicate status codes are not allowed");
                }
                index.put(((StatusType)((Object)status)).getStatusCode(), status);
            }
        }
        return Collections.unmodifiableMap(index);
    }

    public ProblemModule withStackTraces() {
        return this.withStackTraces(true);
    }

    public ProblemModule withStackTraces(boolean stackTraces) {
        return new ProblemModule(stackTraces, this.statuses);
    }
}

