/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.rules;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import gov.cms.fiss.pricers.common.application.request.ClaimMetadata;
import gov.cms.fiss.pricers.common.application.request.RequestContentExtractor;
import io.dropwizard.jackson.Jackson;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CalculationContext<I, O> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculationContext.class);
    public static final String PRICER_CLIENT_HEADER = "cms-pricer-client";
    public static final String WEB_PRICER_CLIENT = "WEB-PRICER";
    protected static final ObjectMapper OUTPUT_MAPPER = Jackson.newObjectMapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
    private final I input;
    private final O output;
    @JsonIgnore
    private final ClaimMetadata headerMetadata;
    @JsonIgnore
    private final ClaimMetadata queryParameterMetadata;
    private boolean calculationCompleted;

    protected CalculationContext(I input, O output) {
        this.input = input;
        this.output = output;
        this.headerMetadata = RequestContentExtractor.requestHeaders();
        this.queryParameterMetadata = RequestContentExtractor.requestQueryParameters();
    }

    public static void customizeDebugOutput(Consumer<ObjectMapper> serializationCustomizer) {
        serializationCustomizer.accept(OUTPUT_MAPPER);
    }

    public boolean isWebPricerRequest() {
        return this.headerMetadata.getClaimMetadata(PRICER_CLIENT_HEADER).contains(WEB_PRICER_CLIENT);
    }

    public boolean isCalculationCompleted() {
        return this.calculationCompleted;
    }

    public void setCalculationCompleted() {
        this.calculationCompleted = true;
    }

    protected final String serializeContent() {
        try {
            return OUTPUT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException jpe) {
            LOGGER.warn("Unable to capture calculation context", jpe);
            return "Context not available";
        }
    }

    @Generated
    public I getInput() {
        return this.input;
    }

    @Generated
    public O getOutput() {
        return this.output;
    }

    @Generated
    public ClaimMetadata getHeaderMetadata() {
        return this.headerMetadata;
    }

    @Generated
    public ClaimMetadata getQueryParameterMetadata() {
        return this.queryParameterMetadata;
    }

    static {
        OUTPUT_MAPPER.setConfig((DeserializationConfig)OUTPUT_MAPPER.getDeserializationConfig().with(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY}));
        OUTPUT_MAPPER.setConfig((SerializationConfig)OUTPUT_MAPPER.getSerializationConfig().with(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY}));
    }
}

