/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipf.api.v2.AdditionalVariableData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.api.v2.IpfPaymentData;
import gov.cms.fiss.pricers.ipf.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ipf.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ipf.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public abstract class IpfPricerContext
extends CalculationContext<IpfClaimPricingRequest, IpfClaimPricingResponse> {
    public static final BigDecimal DEFAULT_COST_OF_LIVING_ADJUSTMENT = new BigDecimal("1.000");
    public static final LocalDate FISCAL_YEAR_2022_BEGIN = LocalDate.of(2021, 10, 1);
    public static final LocalDate FISCAL_YEAR_2022_END = LocalDate.of(2022, 9, 30);
    public static final LocalDate FISCAL_YEAR_2025_BEGIN = LocalDate.of(2024, 10, 1);
    public static final BigDecimal WAGE_INDEX_REDUCTION_FOR_2021 = new BigDecimal("-0.05");
    public static final BigDecimal WAGE_INDEX_ADJUSTMENT_FOR_2021 = new BigDecimal("0.95");
    public static final String PATIENT_STATUS_EXP_TO_REMAIN_A_PATIENT_30 = "30";
    private static final BigDecimal RURAL_ADJUSTMENT = new BigDecimal("1.17");
    private static final BigDecimal TRANSITIONAL_RURAL_ADJUSTMENT = new BigDecimal("1.00");
    public static final BigDecimal DEFAULT_RURAL_ADJUSTMENT = new BigDecimal("1.00");
    private static final BigDecimal INTERN_RATIO_EXPONENT = new BigDecimal("0.5150");
    private static final BigDecimal DEFAULT_EMERGENCY_ADJUSTMENT = new BigDecimal("1.19");
    private static final BigDecimal TEMPORARY_RELIEF_EMERGENCY_ADJUSTMENT = new BigDecimal("1.31");
    private static final BigDecimal SOURCE_OF_ADMISSION_EMERGENCY_ADJUSTMENT = new BigDecimal("1.19");
    private static final List<BigDecimal> dayValues = List.of(new BigDecimal("1.12"), new BigDecimal("1.08"), new BigDecimal("1.05"), new BigDecimal("1.04"), new BigDecimal("1.02"), new BigDecimal("1.01"), new BigDecimal("1.01"), new BigDecimal("1.00"), new BigDecimal("1.00"), new BigDecimal("0.99"), new BigDecimal("0.99"), new BigDecimal("0.99"), new BigDecimal("0.99"), new BigDecimal("0.98"), new BigDecimal("0.97"), new BigDecimal("0.97"), new BigDecimal("0.96"), new BigDecimal("0.95"), new BigDecimal("0.95"), new BigDecimal("0.95"), new BigDecimal("0.92"));
    private static final Map<String, BigDecimal> diagnosticCodeAdjustment = Map.ofEntries(Map.entry("1", new BigDecimal("1.04")), Map.entry("2", new BigDecimal("1.13")), Map.entry("3", new BigDecimal("1.06")), Map.entry("4", new BigDecimal("1.11")), Map.entry("5", new BigDecimal("1.11")), Map.entry("6", new BigDecimal("1.07")), Map.entry("7", new BigDecimal("1.05")), Map.entry("8", new BigDecimal("1.13")), Map.entry("9", new BigDecimal("1.12")), Map.entry("10", new BigDecimal("1.07")), Map.entry("11", new BigDecimal("1.03")), Map.entry("12", new BigDecimal("1.11")), Map.entry("13", new BigDecimal("1.10")), Map.entry("14", new BigDecimal("1.12")), Map.entry("15", new BigDecimal("1.08")), Map.entry("16", new BigDecimal("1.09")), Map.entry("17", new BigDecimal("1.11")));
    private static final NavigableMap<Integer, BigDecimal> ageAdjustmentMap = new TreeMap<Integer, BigDecimal>(Map.of(0, new BigDecimal("1.00"), 45, new BigDecimal("1.01"), 50, new BigDecimal("1.02"), 55, new BigDecimal("1.04"), 60, new BigDecimal("1.07"), 65, new BigDecimal("1.10"), 70, new BigDecimal("1.13"), 75, new BigDecimal("1.15"), 80, new BigDecimal("1.17")));
    @JsonIgnore
    private final DataTables dataTables;
    private CbsaWageIndexEntry cbsaWageIndexEntry;
    private BigDecimal federalPayment;
    private BigDecimal perDiemAmount;
    private BigDecimal federalPortion;
    private BigDecimal teachingPortion = BigDecimalUtils.ZERO;
    @FixedValue
    private BigDecimal day1Value = new BigDecimal("0.00");
    Map<String, Boolean> comorbidityCategory = new HashMap<String, Boolean>();

    protected IpfPricerContext(IpfClaimPricingRequest input, IpfClaimPricingResponse output, DataTables dataTables) {
        super(input, output);
        this.dataTables = dataTables;
        this.initializeOutput();
    }

    protected void initializeOutput() {
        ((IpfClaimPricingResponse)this.getOutput()).setCalculationVersion(this.getCalculationVersion());
        ((IpfPaymentData)((IpfClaimPricingResponse)this.getOutput()).getPaymentData()).setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
    }

    public IpfClaimData getClaimData() {
        return (IpfClaimData)((IpfClaimPricingRequest)this.getInput()).getClaimData();
    }

    public List<String> getDiagnosisCodes() {
        List<String> codes = new ArrayList<String>();
        if (this.getClaimData().getDiagnosisCodes() != null) {
            codes = this.getClaimData().getDiagnosisCodes();
        }
        return codes;
    }

    public List<String> getProcedureCodes() {
        List<String> codes = new ArrayList<String>();
        if (this.getClaimData().getProcedureCodes() != null) {
            codes = this.getClaimData().getProcedureCodes();
        }
        return codes;
    }

    public InpatientProviderData getProviderData() {
        return (InpatientProviderData)((IpfClaimPricingRequest)this.getInput()).getProviderData();
    }

    public IpfPaymentData getPaymentData() {
        return (IpfPaymentData)((IpfClaimPricingResponse)this.getOutput()).getPaymentData();
    }

    public AdditionalVariableData getAdditionalVariables() {
        return this.getPaymentData().getAdditionalVariables();
    }

    public abstract String getCalculationVersion();

    public abstract @FixedValue BigDecimal getHighQualityBudgetRate();

    public abstract @FixedValue BigDecimal getHighQualityEctRate();

    public abstract @FixedValue BigDecimal getLowQualityBudgetRate();

    public abstract @FixedValue BigDecimal getLowQualityEctRate();

    public abstract @FixedValue BigDecimal getOutlierThreshold();

    public abstract @FixedValue BigDecimal getLaborShare();

    public abstract @FixedValue BigDecimal getNonLaborShare();

    public @FixedValue BigDecimal getRuralAdjustment() {
        return RURAL_ADJUSTMENT;
    }

    public @FixedValue BigDecimal getTransitionalRuralAdjustment() {
        return TRANSITIONAL_RURAL_ADJUSTMENT;
    }

    public @FixedValue BigDecimal getDefaultRuralAdjustment() {
        return DEFAULT_RURAL_ADJUSTMENT;
    }

    public @FixedValue BigDecimal getDefaultEmergencyAdjustment() {
        return DEFAULT_EMERGENCY_ADJUSTMENT;
    }

    public @FixedValue BigDecimal getTemporaryReliefEmergencyAdjustment() {
        return TEMPORARY_RELIEF_EMERGENCY_ADJUSTMENT;
    }

    public @FixedValue BigDecimal getSourceOfAdmissionEmergencyAdjustment() {
        return SOURCE_OF_ADMISSION_EMERGENCY_ADJUSTMENT;
    }

    public @FixedValue BigDecimal getInternRatioExponent() {
        return INTERN_RATIO_EXPONENT;
    }

    public boolean matchesReturnCode(ReturnCode code) {
        return ReturnCode.fromCode(Integer.parseInt(((IpfClaimPricingResponse)this.getOutput()).getReturnCodeData().getCode())) == code;
    }

    public void completeWithReturnCode(ReturnCode code) {
        this.applyReturnCode(code);
        this.setCalculationCompleted();
    }

    public void applyReturnCode(ReturnCode code) {
        ((IpfClaimPricingResponse)this.getOutput()).setReturnCodeData(code.toReturnCodeData());
    }

    public boolean isSourceOfAdmission() {
        return StringUtils.equals(this.getClaimData().getSourceOfAdmission(), "D");
    }

    public boolean isOutlierOccurrenceIndicator() {
        return StringUtils.equals(this.getClaimData().getOutlierOccurrenceIndicator(), "Y");
    }

    public boolean hasCostOfLivingAdjustment() {
        return StringUtils.equalsAny(this.getProviderData().getProviderCcn().substring(0, 2), "02", "12");
    }

    public @FixedValue BigDecimal getDayValue(int day) {
        if (day == 0) {
            return this.day1Value;
        }
        return dayValues.get(day - 1);
    }

    public @FixedValue BigDecimal getAgeAdjustment(int age) {
        return ageAdjustmentMap.floorEntry(age).getValue();
    }

    public void setDay1Value(BigDecimal value) {
        this.day1Value = value;
    }

    public @FixedValue BigDecimal getDiagnosticCodeAdjustment(String category) {
        return diagnosticCodeAdjustment.get(category);
    }

    public boolean hasTemporaryReliefIndicator() {
        return StringUtils.equals(this.getProviderData().getTemporaryReliefIndicator(), "Y");
    }

    @Generated
    public DataTables getDataTables() {
        return this.dataTables;
    }

    @Generated
    public CbsaWageIndexEntry getCbsaWageIndexEntry() {
        return this.cbsaWageIndexEntry;
    }

    @Generated
    public void setCbsaWageIndexEntry(CbsaWageIndexEntry cbsaWageIndexEntry) {
        this.cbsaWageIndexEntry = cbsaWageIndexEntry;
    }

    @Generated
    public BigDecimal getFederalPayment() {
        return this.federalPayment;
    }

    @Generated
    public void setFederalPayment(BigDecimal federalPayment) {
        this.federalPayment = federalPayment;
    }

    @Generated
    public BigDecimal getPerDiemAmount() {
        return this.perDiemAmount;
    }

    @Generated
    public void setPerDiemAmount(BigDecimal perDiemAmount) {
        this.perDiemAmount = perDiemAmount;
    }

    @Generated
    public BigDecimal getFederalPortion() {
        return this.federalPortion;
    }

    @Generated
    public void setFederalPortion(BigDecimal federalPortion) {
        this.federalPortion = federalPortion;
    }

    @Generated
    public BigDecimal getTeachingPortion() {
        return this.teachingPortion;
    }

    @Generated
    public void setTeachingPortion(BigDecimal teachingPortion) {
        this.teachingPortion = teachingPortion;
    }

    @Generated
    public Map<String, Boolean> getComorbidityCategory() {
        return this.comorbidityCategory;
    }

    @Generated
    public void setComorbidityCategory(Map<String, Boolean> comorbidityCategory) {
        this.comorbidityCategory = comorbidityCategory;
    }
}

