/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.codes;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum ReturnCode {
    NORMAL_PAYMENT_0(0, "NORMAL PAYMENT", "Normal Payment"),
    OUTLIER_2(2, "OUTLIER", "Outlier"),
    WITH_PRIOR_DAYS_3(3, "WITH PRIOR DAYS", "With prior days"),
    OUTLIER_WITH_PRIOR_DAYS_4(4, "OUTLIER WITH PRIOR DAYS", "Outlier with prior days"),
    STATISTICAL_AREA_NOT_FOUND_52(52, "STATISTICAL AREA NOT FOUND", "Statistical area not found"),
    INVALID_WAIVER_STATE_53(53, "INVALID WAIVER STATE", "Invalid waiver state"),
    INVALID_DIAGNOSIS_RELATED_GROUP_54(54, "INVALID DIAGNOSIS RELATED GROUP", "Invalid diagnosis related group"),
    INVALID_DISCHARGE_DATE_55(55, "INVALID DISCHARGE DATE", "Invalid discharge date"),
    INVALID_LENGTH_OF_STAY_56(56, "INVALID LENGTH OF STAY", "Invalid length of stay"),
    INVALID_AGE_57(57, "INVALID AGE", "Invalid age");

    private final int code;
    private final String desc;
    private final String exp;

    private ReturnCode(int code, String desc, String exp) {
        this.code = code;
        this.desc = desc;
        this.exp = exp;
    }

    public static ReturnCode fromCode(int code) {
        return Arrays.stream(ReturnCode.values()).filter(resultCode -> resultCode.getCode() == code).findFirst().orElse(null);
    }

    public ReturnCodeData toReturnCodeData() {
        ReturnCodeData returnCodeData = new ReturnCodeData();
        String paddedCode = StringUtils.leftPad(Integer.toString(this.getCode()), 2, "0");
        returnCodeData.setCode(paddedCode);
        returnCodeData.setDescription(this.desc);
        returnCodeData.setExplanation(this.exp);
        return returnCodeData;
    }

    public boolean isErrorCode() {
        return STATISTICAL_AREA_NOT_FOUND_52.equals((Object)this) || INVALID_WAIVER_STATE_53.equals((Object)this) || INVALID_DIAGNOSIS_RELATED_GROUP_54.equals((Object)this) || INVALID_DISCHARGE_DATE_55.equals((Object)this) || INVALID_LENGTH_OF_STAY_56.equals((Object)this) || INVALID_AGE_57.equals((Object)this);
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public String getExp() {
        return this.exp;
    }
}

