/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.assemble_pps_variables;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.tables.ComorbidityTableEntry;
import gov.cms.fiss.pricers.ipf.core.tables.ProcedureTableEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CalculateDiagnosisComorbidity
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        IpfClaimData claimData = calculationContext.getClaimData();
        @FixedValue BigDecimal comorbidityFactor = new BigDecimal("1.0000");
        HashMap<String, Boolean> comorbidityCategories = new HashMap<String, Boolean>();
        List<String> diagnosisCodes = calculationContext.getDiagnosisCodes();
        for (int i2 = 1; i2 < diagnosisCodes.size(); ++i2) {
            String category;
            ComorbidityTableEntry diagnosticComorbidity;
            String diagnosticCode = diagnosisCodes.get(i2);
            if (StringUtils.equals(diagnosticCode, "U071") && LocalDateUtils.isBefore(claimData.getDischargeDate(), LocalDate.of(2020, 4, 1)) || (diagnosticComorbidity = calculationContext.getDataTables().getComorbidityTableEntry(diagnosticCode)) == null || Boolean.TRUE.equals(comorbidityCategories.get(category = diagnosticComorbidity.getCategory())) || StringUtils.equals(category, "6") && !this.isProcedureEligible(calculationContext)) continue;
            comorbidityCategories.put(category, true);
            comorbidityFactor = comorbidityFactor.multiply(BigDecimalUtils.defaultValue(calculationContext.getDiagnosticCodeAdjustment(category), BigDecimal.ONE)).setScale(4, RoundingMode.HALF_UP);
        }
        calculationContext.setComorbidityCategory(comorbidityCategories);
        calculationContext.getPaymentData().setComorbidityFactor(comorbidityFactor);
    }

    protected boolean isProcedureEligible(IpfPricerContext calculationContext) {
        IpfClaimData claimData = calculationContext.getClaimData();
        boolean isEligibleProcedure = false;
        for (String procedureCode : claimData.getProcedureCodes()) {
            ProcedureTableEntry procedureComorbidity = calculationContext.getDataTables().getProcedureTableEntry(procedureCode);
            if (procedureComorbidity == null) continue;
            String category = procedureComorbidity.getCategory();
            LocalDate date = procedureComorbidity.getEffectiveDate();
            if (StringUtils.equals(category, "14") || !LocalDateUtils.isAfterOrEqual(claimData.getDischargeDate(), date)) continue;
            isEligibleProcedure = true;
            break;
        }
        return isEligibleProcedure;
    }
}

