/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.assemble_pps_variables;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class CalculateRuralAdjustmentForOutput
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        String geolocation = calculationContext.getProviderData().getCbsaActualGeographicLocation();
        BigDecimal ruralAdjustment = geolocation.length() < 3 || geolocation.substring(0, geolocation.length() - 2).isBlank() ? calculationContext.getRuralAdjustment() : (geolocation.length() == 5 && StringUtils.equals(providerData.getSupplementalWageIndexIndicator(), "3") ? calculationContext.getTransitionalRuralAdjustment() : calculationContext.getDefaultRuralAdjustment());
        calculationContext.getPaymentData().setRuralAdjustmentPercent(ruralAdjustment);
    }
}

