/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipf.api.v2.AdditionalVariableData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.api.v2.IpfPaymentData;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateTeachingAdjustedPerDiemBasis
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        AdditionalVariableData additionalVariables = calculationContext.getAdditionalVariables();
        IpfPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal perDiem = paymentData.getComorbidityFactor().multiply(paymentData.getAgeAdjustmentPercent()).multiply(paymentData.getDiagnosisRelatedGroupFactor()).multiply(paymentData.getTeachingAdjustmentPercent()).multiply(paymentData.getRuralAdjustmentPercent()).multiply(additionalVariables.getWageAdjustedAmount()).setScale(2, RoundingMode.HALF_UP);
        calculationContext.setPerDiemAmount(perDiem.subtract(additionalVariables.getAdjustedPerDiemAmount()));
        additionalVariables.setAdjustedPerDiemAmount(perDiem);
    }
}

