/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipf.api.v2.AdditionalVariableData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.api.v2.IpfPaymentData;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class FinalizePayment
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        IpfClaimData claimData = calculationContext.getClaimData();
        AdditionalVariableData additionalVariables = calculationContext.getAdditionalVariables();
        IpfPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal federalPortion = calculationContext.getFederalPortion();
        BigDecimal teachingPortion = calculationContext.getTeachingPortion();
        BigDecimal outlierPayment = BigDecimalUtils.defaultValue(additionalVariables.getOutlierPayment());
        BigDecimal ectPayment = additionalVariables.getElectroConvulsiveTherapyPayment();
        additionalVariables.setStopLossAmount(federalPortion.add(outlierPayment).add(ectPayment).add(teachingPortion));
        BigDecimal federalPayment = federalPortion.setScale(2, RoundingMode.HALF_UP);
        additionalVariables.setFederalPayment(federalPayment);
        additionalVariables.setTeachingPayment(teachingPortion);
        BigDecimal factorPayment = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);
        additionalVariables.setFactorPayment(factorPayment);
        paymentData.setTotalPayment(federalPayment.add(factorPayment).add(ectPayment).add(teachingPortion).add(outlierPayment));
        if (claimData.getPriorDays() > 0) {
            if (calculationContext.matchesReturnCode(ReturnCode.NORMAL_PAYMENT_0)) {
                calculationContext.applyReturnCode(ReturnCode.WITH_PRIOR_DAYS_3);
            } else if (calculationContext.matchesReturnCode(ReturnCode.OUTLIER_2)) {
                calculationContext.applyReturnCode(ReturnCode.OUTLIER_WITH_PRIOR_DAYS_4);
            }
        }
    }
}

