/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.pre_processing;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ipf.core.tables.CbsaWageIndexEntry;
import org.apache.commons.lang3.StringUtils;

public class SetSpecialWageIndexInContext
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.equalsAny(providerData.getSpecialPaymentIndicator(), "1", "2")) {
            if (BigDecimalUtils.isZero(providerData.getSpecialWageIndex())) {
                calculationContext.completeWithReturnCode(ReturnCode.STATISTICAL_AREA_NOT_FOUND_52);
                return;
            }
            CbsaWageIndexEntry specialWageIndex = CbsaWageIndexEntry.builder().cbsa("SPEC*").effectiveDate(providerData.getEffectiveDate()).geographicWageIndex(providerData.getSpecialWageIndex()).build();
            calculationContext.setCbsaWageIndexEntry(specialWageIndex);
        }
    }
}

