/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.pre_processing;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.codes.ReturnCode;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class ValidateSupplementalWageIndex
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        LocalDate effectiveDate = providerData.getEffectiveDate();
        IpfClaimData claimData = calculationContext.getClaimData();
        if ((StringUtils.equals(providerData.getSupplementalWageIndexIndicator(), "1") || StringUtils.equals(providerData.getSupplementalWageIndexIndicator(), "3") && LocalDateUtils.isAfterOrEqual(claimData.getDischargeDate(), IpfPricerContext.FISCAL_YEAR_2025_BEGIN)) && (BigDecimalUtils.isLessThanOrEqualToZero(providerData.getSupplementalWageIndex()) || LocalDateUtils.inRange(effectiveDate, IpfPricerContext.FISCAL_YEAR_2022_BEGIN, IpfPricerContext.FISCAL_YEAR_2022_END))) {
            calculationContext.completeWithReturnCode(ReturnCode.STATISTICAL_AREA_NOT_FOUND_52);
        }
    }
}

