/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipf.core.tables.ComorbidityTableEntry;
import java.util.List;
import java.util.Map;

public class ComorbidityLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/comorbidities-%s.csv";
    private final CsvContentReader<ComorbidityTableEntry> contentProvider = new CsvContentReader<ComorbidityTableEntry>(ComorbidityTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public ComorbidityLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, ComorbidityTableEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, ComorbidityTableEntry> generate(String csvFile) {
        List<ComorbidityTableEntry> content = this.contentProvider.read(csvFile);
        return LookupGenerator.generateMap(ComorbidityTableEntry::getCode, content);
    }
}

