/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.common;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import io.dropwizard.logging.common.PrefixedExtendedThrowableProxyConverter;
import io.dropwizard.logging.common.PrefixedRootCauseFirstThrowableProxyConverter;
import io.dropwizard.logging.common.PrefixedThrowableProxyConverter;
import java.util.Map;
import java.util.TimeZone;

public class DropwizardLayout
extends PatternLayout {
    public DropwizardLayout(LoggerContext context, TimeZone timeZone) {
        this.setOutputPatternAsHeader(false);
        Map<String, String> defaultConverterMap = this.getDefaultConverterMap();
        defaultConverterMap.put("dwEx", PrefixedThrowableProxyConverter.class.getName());
        defaultConverterMap.put("dwException", PrefixedThrowableProxyConverter.class.getName());
        defaultConverterMap.put("dwThrowable", PrefixedThrowableProxyConverter.class.getName());
        defaultConverterMap.put("dwREx", PrefixedRootCauseFirstThrowableProxyConverter.class.getName());
        defaultConverterMap.put("dwRootException", PrefixedRootCauseFirstThrowableProxyConverter.class.getName());
        defaultConverterMap.put("dwXEx", PrefixedExtendedThrowableProxyConverter.class.getName());
        defaultConverterMap.put("dwXException", PrefixedExtendedThrowableProxyConverter.class.getName());
        defaultConverterMap.put("dwXThrowable", PrefixedExtendedThrowableProxyConverter.class.getName());
        this.setPattern("%-5p [%d{ISO8601," + timeZone.getID() + "}] %c: %m%n%dwREx");
        this.setContext(context);
    }
}

