/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jaxb.internal;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.jersey.jaxb.internal.AbstractJaxbElementProvider;

public abstract class XmlJaxbElementProvider
extends AbstractJaxbElementProvider {
    private final Provider<SAXParserFactory> spf;

    public XmlJaxbElementProvider(Provider<SAXParserFactory> spf, Providers ps, Configuration config) {
        super(ps, config);
        this.spf = spf;
    }

    public XmlJaxbElementProvider(Provider<SAXParserFactory> spf, Providers ps, MediaType mt, Configuration config) {
        super(ps, mt, config);
        this.spf = spf;
    }

    @Override
    protected final JAXBElement<?> readFrom(Class<?> type, MediaType mediaType, Unmarshaller unmarshaller, InputStream entityStream) throws JAXBException {
        return unmarshaller.unmarshal(XmlJaxbElementProvider.getSAXSource(this.spf.get(), entityStream), type);
    }

    @Override
    protected final void writeTo(JAXBElement<?> t2, MediaType mediaType, Charset c, Marshaller m4, OutputStream entityStream) throws JAXBException {
        m4.marshal(t2, entityStream);
    }

    @Produces(value={"*/*,*/*+xml"})
    @Consumes(value={"*/*,*/*+xml"})
    @Singleton
    public static final class General
    extends XmlJaxbElementProvider {
        @Inject
        public General(@Context Provider<SAXParserFactory> spf, @Context Providers ps, @Context Configuration config) {
            super(spf, ps, config);
        }

        @Override
        protected boolean isSupported(MediaType m4) {
            return m4.getSubtype().endsWith("+xml");
        }
    }

    @Produces(value={"text/xml"})
    @Consumes(value={"text/xml"})
    @Singleton
    public static final class Text
    extends XmlJaxbElementProvider {
        @Inject
        public Text(@Context Provider<SAXParserFactory> spf, @Context Providers ps, @Context Configuration config) {
            super(spf, ps, MediaType.TEXT_XML_TYPE, config);
        }
    }

    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    @Singleton
    public static final class App
    extends XmlJaxbElementProvider {
        @Inject
        public App(@Context Provider<SAXParserFactory> spf, @Context Providers ps, @Context Configuration config) {
            super(spf, ps, MediaType.APPLICATION_XML_TYPE, config);
        }
    }
}

