/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.zalando.problem.GenericProblems;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@API(status=API.Status.STABLE)
public interface Problem {
    public static final URI DEFAULT_TYPE = URI.create("about:blank");

    default public URI getType() {
        return DEFAULT_TYPE;
    }

    default public @Nullable String getTitle() {
        return null;
    }

    default public @Nullable StatusType getStatus() {
        return null;
    }

    default public @Nullable String getDetail() {
        return null;
    }

    default public @Nullable URI getInstance() {
        return null;
    }

    default public Map<String, Object> getParameters() {
        return Collections.emptyMap();
    }

    public static ProblemBuilder builder() {
        return new ProblemBuilder();
    }

    public static ThrowableProblem valueOf(StatusType status) {
        return GenericProblems.create(status).build();
    }

    public static ThrowableProblem valueOf(StatusType status, @Nullable String detail) {
        return GenericProblems.create(status).withDetail(detail).build();
    }

    public static ThrowableProblem valueOf(StatusType status, @Nullable URI instance) {
        return GenericProblems.create(status).withInstance(instance).build();
    }

    public static ThrowableProblem valueOf(StatusType status, @Nullable String detail, @Nullable URI instance) {
        return GenericProblems.create(status).withDetail(detail).withInstance(instance).build();
    }

    public static String toString(Problem problem) {
        Stream<String> parts = Stream.concat(Stream.of(problem.getStatus() == null ? null : String.valueOf(problem.getStatus().getStatusCode()), problem.getTitle(), problem.getDetail(), problem.getInstance() == null ? null : "instance=" + problem.getInstance()), problem.getParameters().entrySet().stream().map(Object::toString)).filter(Objects::nonNull);
        return problem.getType().toString() + "{" + parts.collect(Collectors.joining(", ")) + "}";
    }
}

