// Generated by delombok at Mon Oct 04 13:52:54 EDT 2021
package gov.cms.fiss.pricers.ipps.api;

import gov.cms.fiss.pricers.common.api.RecordBase;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class BillingRecord extends RecordBase {
  @Schema(description = "Length of stay of billing request", example = "5")
  @NotNull
  private Integer lengthOfStay;
  @Schema(description = "Covered Days of billing request", example = "5")
  @NotNull
  private Integer coveredDays;
  @Schema(description = "Lifetime reserve days of billing request", example = "0")
  @NotNull
  private Integer lifetimeReserveDays;
  @Schema(description = "Discharge date of billing request. This cannot be empty.", example = "20190415")
  @NotBlank
  @Size(min = 8, max = 8)
  private String dischargeDate;
  @Schema(description = "Code documenting state of review. 11 = Transfer special drug, no cost.", example = "11")
  @NotNull
  private Integer reviewCode;
  @Schema(description = "Diagnosis Related Group. Format int", example = "981")
  @NotNull
  private Integer diagnosisRelatedGroup;
  @Schema(description = "The charges claimed. Format BigDecimal rounded to the hundredth.", example = "3945227.01")
  @NotNull
  @DecimalMin("0000000.00")
  @DecimalMax("9999999.99")
  private BigDecimal chargesClaimed;
  @Schema(description = "The national drug code number. Use `nationalDrugCodes` instead.", example = "70842012001", deprecated = true)
  @Size(min = 9, max = 11)
  private String nationalDrugCodeNbr;
  @ArraySchema(arraySchema = @Schema(description = "A list of national drug codes.", example = "[\"70842012001\", \"65293000901\", \"00000000000\", \"00000000000\"]"))
  @Size(max = 10)
  private List<@NotBlank @Size(min = 9, max = 11) String> nationalDrugCodes = new ArrayList<>();
  @ArraySchema(arraySchema = @Schema(description = "A list of procedure codes.", example = "[\"04VD3FZ\", \"XNS0032\", \"XW033F3\", \"3E0J7U1\", \"3E0J7U1\", \"0JH60DZ\"]"))
  private List<String> procedureCodes = new ArrayList<>();
  @ArraySchema(arraySchema = @Schema(description = "A list of diagnosis codes.", example = "[\"N390\", \"B952\", \"I130\", \"I5032\", \"N179\", \"M25511\", \"M549\"]"))
  private List<String> diagnosisCodes = new ArrayList<>();
  @Schema(description = "Demo code 1. Use `demoCodes` instead.", example = "61", deprecated = true)
  @Size(max = 2)
  private String demoCode1;
  @Schema(description = "Demo code 2. Use `demoCodes` instead.", example = "61", deprecated = true)
  @Size(max = 2)
  private String demoCode2;
  @Schema(description = "Demo code 3. Use `demoCodes` instead.", example = "61", deprecated = true)
  @Size(max = 2)
  private String demoCode3;
  @Schema(description = "Demo code 4. Use `demoCodes` instead.", example = "61", deprecated = true)
  @Size(max = 2)
  private String demoCode4;
  @ArraySchema(arraySchema = @Schema(description = "A list of demo codes.", example = "[\"61\", \"00\", \"00\", \"00\"]"))
  @Size(max = 4)
  private List<@Size(max = 2) String> demoCodes = new ArrayList<>();
  @ArraySchema(arraySchema = @Schema(description = "A list of condition codes.", example = "[\"ZA\", \"ZB\", \"ZC\", \"ZD\", \"ZE\"]"), uniqueItems = true)
  private List<String> conditionCodes = new ArrayList<>();

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BillingRecord() {
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getLengthOfStay() {
    return this.lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCoveredDays() {
    return this.coveredDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getLifetimeReserveDays() {
    return this.lifetimeReserveDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDischargeDate() {
    return this.dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getReviewCode() {
    return this.reviewCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getDiagnosisRelatedGroup() {
    return this.diagnosisRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getChargesClaimed() {
    return this.chargesClaimed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNationalDrugCodeNbr() {
    return this.nationalDrugCodeNbr;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotBlank @Size(min = 9, max = 11) String> getNationalDrugCodes() {
    return this.nationalDrugCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getProcedureCodes() {
    return this.procedureCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getDiagnosisCodes() {
    return this.diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDemoCode1() {
    return this.demoCode1;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDemoCode2() {
    return this.demoCode2;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDemoCode3() {
    return this.demoCode3;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDemoCode4() {
    return this.demoCode4;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Size(max = 2) String> getDemoCodes() {
    return this.demoCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getConditionCodes() {
    return this.conditionCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLengthOfStay(final Integer lengthOfStay) {
    this.lengthOfStay = lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoveredDays(final Integer coveredDays) {
    this.coveredDays = coveredDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLifetimeReserveDays(final Integer lifetimeReserveDays) {
    this.lifetimeReserveDays = lifetimeReserveDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDischargeDate(final String dischargeDate) {
    this.dischargeDate = dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReviewCode(final Integer reviewCode) {
    this.reviewCode = reviewCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisRelatedGroup(final Integer diagnosisRelatedGroup) {
    this.diagnosisRelatedGroup = diagnosisRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setChargesClaimed(final BigDecimal chargesClaimed) {
    this.chargesClaimed = chargesClaimed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalDrugCodeNbr(final String nationalDrugCodeNbr) {
    this.nationalDrugCodeNbr = nationalDrugCodeNbr;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalDrugCodes(final List<@NotBlank @Size(min = 9, max = 11) String> nationalDrugCodes) {
    this.nationalDrugCodes = nationalDrugCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProcedureCodes(final List<String> procedureCodes) {
    this.procedureCodes = procedureCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisCodes(final List<String> diagnosisCodes) {
    this.diagnosisCodes = diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDemoCode1(final String demoCode1) {
    this.demoCode1 = demoCode1;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDemoCode2(final String demoCode2) {
    this.demoCode2 = demoCode2;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDemoCode3(final String demoCode3) {
    this.demoCode3 = demoCode3;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDemoCode4(final String demoCode4) {
    this.demoCode4 = demoCode4;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDemoCodes(final List<@Size(max = 2) String> demoCodes) {
    this.demoCodes = demoCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConditionCodes(final List<String> conditionCodes) {
    this.conditionCodes = conditionCodes;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof BillingRecord)) return false;
    final BillingRecord other = (BillingRecord) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$lengthOfStay = this.getLengthOfStay();
    final java.lang.Object other$lengthOfStay = other.getLengthOfStay();
    if (this$lengthOfStay == null ? other$lengthOfStay != null : !this$lengthOfStay.equals(other$lengthOfStay)) return false;
    final java.lang.Object this$coveredDays = this.getCoveredDays();
    final java.lang.Object other$coveredDays = other.getCoveredDays();
    if (this$coveredDays == null ? other$coveredDays != null : !this$coveredDays.equals(other$coveredDays)) return false;
    final java.lang.Object this$lifetimeReserveDays = this.getLifetimeReserveDays();
    final java.lang.Object other$lifetimeReserveDays = other.getLifetimeReserveDays();
    if (this$lifetimeReserveDays == null ? other$lifetimeReserveDays != null : !this$lifetimeReserveDays.equals(other$lifetimeReserveDays)) return false;
    final java.lang.Object this$reviewCode = this.getReviewCode();
    final java.lang.Object other$reviewCode = other.getReviewCode();
    if (this$reviewCode == null ? other$reviewCode != null : !this$reviewCode.equals(other$reviewCode)) return false;
    final java.lang.Object this$diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
    final java.lang.Object other$diagnosisRelatedGroup = other.getDiagnosisRelatedGroup();
    if (this$diagnosisRelatedGroup == null ? other$diagnosisRelatedGroup != null : !this$diagnosisRelatedGroup.equals(other$diagnosisRelatedGroup)) return false;
    final java.lang.Object this$dischargeDate = this.getDischargeDate();
    final java.lang.Object other$dischargeDate = other.getDischargeDate();
    if (this$dischargeDate == null ? other$dischargeDate != null : !this$dischargeDate.equals(other$dischargeDate)) return false;
    final java.lang.Object this$chargesClaimed = this.getChargesClaimed();
    final java.lang.Object other$chargesClaimed = other.getChargesClaimed();
    if (this$chargesClaimed == null ? other$chargesClaimed != null : !this$chargesClaimed.equals(other$chargesClaimed)) return false;
    final java.lang.Object this$nationalDrugCodeNbr = this.getNationalDrugCodeNbr();
    final java.lang.Object other$nationalDrugCodeNbr = other.getNationalDrugCodeNbr();
    if (this$nationalDrugCodeNbr == null ? other$nationalDrugCodeNbr != null : !this$nationalDrugCodeNbr.equals(other$nationalDrugCodeNbr)) return false;
    final java.lang.Object this$nationalDrugCodes = this.getNationalDrugCodes();
    final java.lang.Object other$nationalDrugCodes = other.getNationalDrugCodes();
    if (this$nationalDrugCodes == null ? other$nationalDrugCodes != null : !this$nationalDrugCodes.equals(other$nationalDrugCodes)) return false;
    final java.lang.Object this$procedureCodes = this.getProcedureCodes();
    final java.lang.Object other$procedureCodes = other.getProcedureCodes();
    if (this$procedureCodes == null ? other$procedureCodes != null : !this$procedureCodes.equals(other$procedureCodes)) return false;
    final java.lang.Object this$diagnosisCodes = this.getDiagnosisCodes();
    final java.lang.Object other$diagnosisCodes = other.getDiagnosisCodes();
    if (this$diagnosisCodes == null ? other$diagnosisCodes != null : !this$diagnosisCodes.equals(other$diagnosisCodes)) return false;
    final java.lang.Object this$demoCode1 = this.getDemoCode1();
    final java.lang.Object other$demoCode1 = other.getDemoCode1();
    if (this$demoCode1 == null ? other$demoCode1 != null : !this$demoCode1.equals(other$demoCode1)) return false;
    final java.lang.Object this$demoCode2 = this.getDemoCode2();
    final java.lang.Object other$demoCode2 = other.getDemoCode2();
    if (this$demoCode2 == null ? other$demoCode2 != null : !this$demoCode2.equals(other$demoCode2)) return false;
    final java.lang.Object this$demoCode3 = this.getDemoCode3();
    final java.lang.Object other$demoCode3 = other.getDemoCode3();
    if (this$demoCode3 == null ? other$demoCode3 != null : !this$demoCode3.equals(other$demoCode3)) return false;
    final java.lang.Object this$demoCode4 = this.getDemoCode4();
    final java.lang.Object other$demoCode4 = other.getDemoCode4();
    if (this$demoCode4 == null ? other$demoCode4 != null : !this$demoCode4.equals(other$demoCode4)) return false;
    final java.lang.Object this$demoCodes = this.getDemoCodes();
    final java.lang.Object other$demoCodes = other.getDemoCodes();
    if (this$demoCodes == null ? other$demoCodes != null : !this$demoCodes.equals(other$demoCodes)) return false;
    final java.lang.Object this$conditionCodes = this.getConditionCodes();
    final java.lang.Object other$conditionCodes = other.getConditionCodes();
    if (this$conditionCodes == null ? other$conditionCodes != null : !this$conditionCodes.equals(other$conditionCodes)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof BillingRecord;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $lengthOfStay = this.getLengthOfStay();
    result = result * PRIME + ($lengthOfStay == null ? 43 : $lengthOfStay.hashCode());
    final java.lang.Object $coveredDays = this.getCoveredDays();
    result = result * PRIME + ($coveredDays == null ? 43 : $coveredDays.hashCode());
    final java.lang.Object $lifetimeReserveDays = this.getLifetimeReserveDays();
    result = result * PRIME + ($lifetimeReserveDays == null ? 43 : $lifetimeReserveDays.hashCode());
    final java.lang.Object $reviewCode = this.getReviewCode();
    result = result * PRIME + ($reviewCode == null ? 43 : $reviewCode.hashCode());
    final java.lang.Object $diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
    result = result * PRIME + ($diagnosisRelatedGroup == null ? 43 : $diagnosisRelatedGroup.hashCode());
    final java.lang.Object $dischargeDate = this.getDischargeDate();
    result = result * PRIME + ($dischargeDate == null ? 43 : $dischargeDate.hashCode());
    final java.lang.Object $chargesClaimed = this.getChargesClaimed();
    result = result * PRIME + ($chargesClaimed == null ? 43 : $chargesClaimed.hashCode());
    final java.lang.Object $nationalDrugCodeNbr = this.getNationalDrugCodeNbr();
    result = result * PRIME + ($nationalDrugCodeNbr == null ? 43 : $nationalDrugCodeNbr.hashCode());
    final java.lang.Object $nationalDrugCodes = this.getNationalDrugCodes();
    result = result * PRIME + ($nationalDrugCodes == null ? 43 : $nationalDrugCodes.hashCode());
    final java.lang.Object $procedureCodes = this.getProcedureCodes();
    result = result * PRIME + ($procedureCodes == null ? 43 : $procedureCodes.hashCode());
    final java.lang.Object $diagnosisCodes = this.getDiagnosisCodes();
    result = result * PRIME + ($diagnosisCodes == null ? 43 : $diagnosisCodes.hashCode());
    final java.lang.Object $demoCode1 = this.getDemoCode1();
    result = result * PRIME + ($demoCode1 == null ? 43 : $demoCode1.hashCode());
    final java.lang.Object $demoCode2 = this.getDemoCode2();
    result = result * PRIME + ($demoCode2 == null ? 43 : $demoCode2.hashCode());
    final java.lang.Object $demoCode3 = this.getDemoCode3();
    result = result * PRIME + ($demoCode3 == null ? 43 : $demoCode3.hashCode());
    final java.lang.Object $demoCode4 = this.getDemoCode4();
    result = result * PRIME + ($demoCode4 == null ? 43 : $demoCode4.hashCode());
    final java.lang.Object $demoCodes = this.getDemoCodes();
    result = result * PRIME + ($demoCodes == null ? 43 : $demoCodes.hashCode());
    final java.lang.Object $conditionCodes = this.getConditionCodes();
    result = result * PRIME + ($conditionCodes == null ? 43 : $conditionCodes.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "BillingRecord(lengthOfStay=" + this.getLengthOfStay() + ", coveredDays=" + this.getCoveredDays() + ", lifetimeReserveDays=" + this.getLifetimeReserveDays() + ", dischargeDate=" + this.getDischargeDate() + ", reviewCode=" + this.getReviewCode() + ", diagnosisRelatedGroup=" + this.getDiagnosisRelatedGroup() + ", chargesClaimed=" + this.getChargesClaimed() + ", nationalDrugCodeNbr=" + this.getNationalDrugCodeNbr() + ", nationalDrugCodes=" + this.getNationalDrugCodes() + ", procedureCodes=" + this.getProcedureCodes() + ", diagnosisCodes=" + this.getDiagnosisCodes() + ", demoCode1=" + this.getDemoCode1() + ", demoCode2=" + this.getDemoCode2() + ", demoCode3=" + this.getDemoCode3() + ", demoCode4=" + this.getDemoCode4() + ", demoCodes=" + this.getDemoCodes() + ", conditionCodes=" + this.getConditionCodes() + ")";
  }
}
