// Generated by delombok at Mon Oct 04 13:52:54 EDT 2021
package gov.cms.fiss.pricers.ipps.api;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictIsoLocalDateSerializer;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
// NOTE: Field name references/ordering are not used for reading because the field names are mapped
// via a header row in the CSV file
@Schema(description = "The per-CBSA wage index data.")
public class CbsaTableEntry {
  @NotNull
  @Pattern(regexp = "\\d{2}|[1-9]\\d{4}", message = "must be either 2 or 5 digits")
  @Schema(description = "Core-based statistical area (CBSA) code.", example = "47472", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "T-CBSA", value = "PIC X(5)")})})
  private String cbsa;
  @JsonSerialize(using = StrictIsoLocalDateSerializer.class)
  @NotNull
  @Schema(description = "The effective date for the wage indexes.", example = "2020-10-20", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "T-CBSA-EFF-DATE", value = "PIC X(08)")})})
  private LocalDate effectiveDate;
  @Schema(description = "A descriptive name for the statistical area.", example = "HAWAII", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "T-CBSA-SIZE", value = "PIC X(01)")})})
  private String name;
  @Pattern(regexp = "[ LRO]?")
  @Schema(description = "The size classification of the CBSA.", example = "L", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "T-CBSA-SIZE", value = "PIC X(01)")})})
  private String size;
  @NotNull
  @Schema(description = "Geographic Wage Index.", example = "1.2354", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "T-CBSA-WAGE-INDX1", value = "PIC S9(02)V9(04)")})})
  @BigDecimalScale(scale = 4)
  @DecimalMax("99.9999")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 4)
  private BigDecimal geographicWageIndex;
  @NotNull
  @Schema(description = "Reclassified Wage Index.", example = "1.2354", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "T-CBSA-WAGE-INDX2", value = "PIC S9(02)V9(04)")})})
  @BigDecimalScale(scale = 4)
  @DecimalMax("99.9999")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 4)
  private BigDecimal reclassifiedWageIndex;
  @Schema(description = "Rural Floor Wage Index.", example = "1.2354", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "T-CBSA-WAGE-INDX3", value = "PIC S9(02)V9(04)")})})
  @BigDecimalScale(scale = 4)
  @DecimalMax("99.9999")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 4)
  private BigDecimal ruralFloorWageIndex;
  @Schema(description = "Imputed Floor Wage Index.", example = "1.2354", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "T-CBSA-WAGE-INDX4", value = "PIC S9(02)V9(04)")})})
  @BigDecimalScale(scale = 4)
  @DecimalMax("99.9999")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 4)
  private BigDecimal imputedFloorWageIndex;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCbsa() {
    return this.cbsa;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getEffectiveDate() {
    return this.effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSize() {
    return this.size;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getGeographicWageIndex() {
    return this.geographicWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getReclassifiedWageIndex() {
    return this.reclassifiedWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRuralFloorWageIndex() {
    return this.ruralFloorWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getImputedFloorWageIndex() {
    return this.imputedFloorWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCbsa(final String cbsa) {
    this.cbsa = cbsa;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEffectiveDate(final LocalDate effectiveDate) {
    this.effectiveDate = effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSize(final String size) {
    this.size = size;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGeographicWageIndex(final BigDecimal geographicWageIndex) {
    this.geographicWageIndex = geographicWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReclassifiedWageIndex(final BigDecimal reclassifiedWageIndex) {
    this.reclassifiedWageIndex = reclassifiedWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRuralFloorWageIndex(final BigDecimal ruralFloorWageIndex) {
    this.ruralFloorWageIndex = ruralFloorWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setImputedFloorWageIndex(final BigDecimal imputedFloorWageIndex) {
    this.imputedFloorWageIndex = imputedFloorWageIndex;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof CbsaTableEntry)) return false;
    final CbsaTableEntry other = (CbsaTableEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$cbsa = this.getCbsa();
    final java.lang.Object other$cbsa = other.getCbsa();
    if (this$cbsa == null ? other$cbsa != null : !this$cbsa.equals(other$cbsa)) return false;
    final java.lang.Object this$effectiveDate = this.getEffectiveDate();
    final java.lang.Object other$effectiveDate = other.getEffectiveDate();
    if (this$effectiveDate == null ? other$effectiveDate != null : !this$effectiveDate.equals(other$effectiveDate)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$size = this.getSize();
    final java.lang.Object other$size = other.getSize();
    if (this$size == null ? other$size != null : !this$size.equals(other$size)) return false;
    final java.lang.Object this$geographicWageIndex = this.getGeographicWageIndex();
    final java.lang.Object other$geographicWageIndex = other.getGeographicWageIndex();
    if (this$geographicWageIndex == null ? other$geographicWageIndex != null : !this$geographicWageIndex.equals(other$geographicWageIndex)) return false;
    final java.lang.Object this$reclassifiedWageIndex = this.getReclassifiedWageIndex();
    final java.lang.Object other$reclassifiedWageIndex = other.getReclassifiedWageIndex();
    if (this$reclassifiedWageIndex == null ? other$reclassifiedWageIndex != null : !this$reclassifiedWageIndex.equals(other$reclassifiedWageIndex)) return false;
    final java.lang.Object this$ruralFloorWageIndex = this.getRuralFloorWageIndex();
    final java.lang.Object other$ruralFloorWageIndex = other.getRuralFloorWageIndex();
    if (this$ruralFloorWageIndex == null ? other$ruralFloorWageIndex != null : !this$ruralFloorWageIndex.equals(other$ruralFloorWageIndex)) return false;
    final java.lang.Object this$imputedFloorWageIndex = this.getImputedFloorWageIndex();
    final java.lang.Object other$imputedFloorWageIndex = other.getImputedFloorWageIndex();
    if (this$imputedFloorWageIndex == null ? other$imputedFloorWageIndex != null : !this$imputedFloorWageIndex.equals(other$imputedFloorWageIndex)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof CbsaTableEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $cbsa = this.getCbsa();
    result = result * PRIME + ($cbsa == null ? 43 : $cbsa.hashCode());
    final java.lang.Object $effectiveDate = this.getEffectiveDate();
    result = result * PRIME + ($effectiveDate == null ? 43 : $effectiveDate.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $size = this.getSize();
    result = result * PRIME + ($size == null ? 43 : $size.hashCode());
    final java.lang.Object $geographicWageIndex = this.getGeographicWageIndex();
    result = result * PRIME + ($geographicWageIndex == null ? 43 : $geographicWageIndex.hashCode());
    final java.lang.Object $reclassifiedWageIndex = this.getReclassifiedWageIndex();
    result = result * PRIME + ($reclassifiedWageIndex == null ? 43 : $reclassifiedWageIndex.hashCode());
    final java.lang.Object $ruralFloorWageIndex = this.getRuralFloorWageIndex();
    result = result * PRIME + ($ruralFloorWageIndex == null ? 43 : $ruralFloorWageIndex.hashCode());
    final java.lang.Object $imputedFloorWageIndex = this.getImputedFloorWageIndex();
    result = result * PRIME + ($imputedFloorWageIndex == null ? 43 : $imputedFloorWageIndex.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "CbsaTableEntry(cbsa=" + this.getCbsa() + ", effectiveDate=" + this.getEffectiveDate() + ", name=" + this.getName() + ", size=" + this.getSize() + ", geographicWageIndex=" + this.getGeographicWageIndex() + ", reclassifiedWageIndex=" + this.getReclassifiedWageIndex() + ", ruralFloorWageIndex=" + this.getRuralFloorWageIndex() + ", imputedFloorWageIndex=" + this.getImputedFloorWageIndex() + ")";
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String CBSA = "cbsa";
    public static final java.lang.String EFFECTIVE_DATE = "effectiveDate";
    public static final java.lang.String NAME = "name";
    public static final java.lang.String SIZE = "size";
    public static final java.lang.String GEOGRAPHIC_WAGE_INDEX = "geographicWageIndex";
    public static final java.lang.String RECLASSIFIED_WAGE_INDEX = "reclassifiedWageIndex";
    public static final java.lang.String RURAL_FLOOR_WAGE_INDEX = "ruralFloorWageIndex";
    public static final java.lang.String IMPUTED_FLOOR_WAGE_INDEX = "imputedFloorWageIndex";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CbsaTableEntry() {
  }
}
