// Generated by delombok at Mon Oct 04 13:52:54 EDT 2021
package gov.cms.fiss.pricers.ipps.api;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import gov.cms.fiss.pricers.common.api.serialization.StrictIsoLocalDateSerializer;
import gov.cms.fiss.pricers.ipps.api.DrgsTableEntry.Fields;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonPropertyOrder({Fields.DIAGNOSTIC_RELATED_GROUP, Fields.EFFECTIVE_DATE, Fields.WEIGHT, Fields.GEOMETRIC_MEAN_LENGTH_OF_STAY, Fields.LOW_VOLUME_DRG, Fields.ARITHMETIC_MEAN_LENGTH_OF_STAY, Fields.POST_ACUTE_CARE, Fields.SPECIAL_PAYMENT_POST_ACUTE_CARE, Fields.DESCRIPTION})
@Schema(description = "The diagnostic-related group (DRG) information.")
public class DrgsTableEntry {
  @DecimalMax("99.9")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 1)
  @NotNull
  @Schema(description = "Arithmetic mean length of stay.", example = "1.2", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-ARITH-ALOS", value = "PIC 9(02)V9(01)")})})
  private BigDecimal arithmeticMeanLengthOfStay = BigDecimal.ZERO.setScale(1, RoundingMode.UNNECESSARY);
  @NotNull
  @Pattern(regexp = "\\d{3}")
  @Schema(description = "Diagnostic-related group.", example = "077", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "WK-DRG-DRGX", value = "PIC X(03)")})})
  private String diagnosticRelatedGroup;
  @NotNull
  @Schema(description = "Group description.", example = "TRANSIENT ISCHEMIA W/O THR", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-DESC", value = "PIC X(26)")})})
  private String description;
  @JsonSerialize(using = StrictIsoLocalDateSerializer.class)
  @NotNull
  @Schema(description = "Effective date of DRG information.", example = "2018-10-01")
  private LocalDate effectiveDate;
  @DecimalMax("99.9")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 1)
  @Schema(description = "Geometric mean length of stay.", example = "23.4", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-GMALOS", value = "PIC 9(02)V9(01)")})})
  private BigDecimal geometricMeanLengthOfStay = BigDecimal.ZERO.setScale(1, RoundingMode.UNNECESSARY);
  @Schema(description = "Low-volume diagnostic-related group indicator.", example = "077", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-LOW", value = "PIC X(01)")})})
  private String lowVolumeDrg;
  @Pattern(regexp = "Y?")
  @Schema(description = "Post-acute care indicator.", example = "Y", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-PAC", value = "PIC X(01)")})})
  private String postAcuteCare;
  @Pattern(regexp = "Y?")
  @Schema(description = "Special payment post-acute care indicator.", example = "Y", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-SPPAC", value = "PIC X(01)")})})
  private String specialPaymentPostAcuteCare;
  @DecimalMax("99.9999")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 4)
  @Schema(description = "Group weight.", example = "3.3326", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-WEIGHT", value = "PIC 9(02)V9(04)")})})
  private BigDecimal weight = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getArithmeticMeanLengthOfStay() {
    return this.arithmeticMeanLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDiagnosticRelatedGroup() {
    return this.diagnosticRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getEffectiveDate() {
    return this.effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getGeometricMeanLengthOfStay() {
    return this.geometricMeanLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLowVolumeDrg() {
    return this.lowVolumeDrg;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPostAcuteCare() {
    return this.postAcuteCare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSpecialPaymentPostAcuteCare() {
    return this.specialPaymentPostAcuteCare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWeight() {
    return this.weight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setArithmeticMeanLengthOfStay(final BigDecimal arithmeticMeanLengthOfStay) {
    this.arithmeticMeanLengthOfStay = arithmeticMeanLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosticRelatedGroup(final String diagnosticRelatedGroup) {
    this.diagnosticRelatedGroup = diagnosticRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEffectiveDate(final LocalDate effectiveDate) {
    this.effectiveDate = effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGeometricMeanLengthOfStay(final BigDecimal geometricMeanLengthOfStay) {
    this.geometricMeanLengthOfStay = geometricMeanLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumeDrg(final String lowVolumeDrg) {
    this.lowVolumeDrg = lowVolumeDrg;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPostAcuteCare(final String postAcuteCare) {
    this.postAcuteCare = postAcuteCare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSpecialPaymentPostAcuteCare(final String specialPaymentPostAcuteCare) {
    this.specialPaymentPostAcuteCare = specialPaymentPostAcuteCare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWeight(final BigDecimal weight) {
    this.weight = weight;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof DrgsTableEntry)) return false;
    final DrgsTableEntry other = (DrgsTableEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$arithmeticMeanLengthOfStay = this.getArithmeticMeanLengthOfStay();
    final java.lang.Object other$arithmeticMeanLengthOfStay = other.getArithmeticMeanLengthOfStay();
    if (this$arithmeticMeanLengthOfStay == null ? other$arithmeticMeanLengthOfStay != null : !this$arithmeticMeanLengthOfStay.equals(other$arithmeticMeanLengthOfStay)) return false;
    final java.lang.Object this$diagnosticRelatedGroup = this.getDiagnosticRelatedGroup();
    final java.lang.Object other$diagnosticRelatedGroup = other.getDiagnosticRelatedGroup();
    if (this$diagnosticRelatedGroup == null ? other$diagnosticRelatedGroup != null : !this$diagnosticRelatedGroup.equals(other$diagnosticRelatedGroup)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$effectiveDate = this.getEffectiveDate();
    final java.lang.Object other$effectiveDate = other.getEffectiveDate();
    if (this$effectiveDate == null ? other$effectiveDate != null : !this$effectiveDate.equals(other$effectiveDate)) return false;
    final java.lang.Object this$geometricMeanLengthOfStay = this.getGeometricMeanLengthOfStay();
    final java.lang.Object other$geometricMeanLengthOfStay = other.getGeometricMeanLengthOfStay();
    if (this$geometricMeanLengthOfStay == null ? other$geometricMeanLengthOfStay != null : !this$geometricMeanLengthOfStay.equals(other$geometricMeanLengthOfStay)) return false;
    final java.lang.Object this$lowVolumeDrg = this.getLowVolumeDrg();
    final java.lang.Object other$lowVolumeDrg = other.getLowVolumeDrg();
    if (this$lowVolumeDrg == null ? other$lowVolumeDrg != null : !this$lowVolumeDrg.equals(other$lowVolumeDrg)) return false;
    final java.lang.Object this$postAcuteCare = this.getPostAcuteCare();
    final java.lang.Object other$postAcuteCare = other.getPostAcuteCare();
    if (this$postAcuteCare == null ? other$postAcuteCare != null : !this$postAcuteCare.equals(other$postAcuteCare)) return false;
    final java.lang.Object this$specialPaymentPostAcuteCare = this.getSpecialPaymentPostAcuteCare();
    final java.lang.Object other$specialPaymentPostAcuteCare = other.getSpecialPaymentPostAcuteCare();
    if (this$specialPaymentPostAcuteCare == null ? other$specialPaymentPostAcuteCare != null : !this$specialPaymentPostAcuteCare.equals(other$specialPaymentPostAcuteCare)) return false;
    final java.lang.Object this$weight = this.getWeight();
    final java.lang.Object other$weight = other.getWeight();
    if (this$weight == null ? other$weight != null : !this$weight.equals(other$weight)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof DrgsTableEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $arithmeticMeanLengthOfStay = this.getArithmeticMeanLengthOfStay();
    result = result * PRIME + ($arithmeticMeanLengthOfStay == null ? 43 : $arithmeticMeanLengthOfStay.hashCode());
    final java.lang.Object $diagnosticRelatedGroup = this.getDiagnosticRelatedGroup();
    result = result * PRIME + ($diagnosticRelatedGroup == null ? 43 : $diagnosticRelatedGroup.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $effectiveDate = this.getEffectiveDate();
    result = result * PRIME + ($effectiveDate == null ? 43 : $effectiveDate.hashCode());
    final java.lang.Object $geometricMeanLengthOfStay = this.getGeometricMeanLengthOfStay();
    result = result * PRIME + ($geometricMeanLengthOfStay == null ? 43 : $geometricMeanLengthOfStay.hashCode());
    final java.lang.Object $lowVolumeDrg = this.getLowVolumeDrg();
    result = result * PRIME + ($lowVolumeDrg == null ? 43 : $lowVolumeDrg.hashCode());
    final java.lang.Object $postAcuteCare = this.getPostAcuteCare();
    result = result * PRIME + ($postAcuteCare == null ? 43 : $postAcuteCare.hashCode());
    final java.lang.Object $specialPaymentPostAcuteCare = this.getSpecialPaymentPostAcuteCare();
    result = result * PRIME + ($specialPaymentPostAcuteCare == null ? 43 : $specialPaymentPostAcuteCare.hashCode());
    final java.lang.Object $weight = this.getWeight();
    result = result * PRIME + ($weight == null ? 43 : $weight.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "DrgsTableEntry(arithmeticMeanLengthOfStay=" + this.getArithmeticMeanLengthOfStay() + ", diagnosticRelatedGroup=" + this.getDiagnosticRelatedGroup() + ", description=" + this.getDescription() + ", effectiveDate=" + this.getEffectiveDate() + ", geometricMeanLengthOfStay=" + this.getGeometricMeanLengthOfStay() + ", lowVolumeDrg=" + this.getLowVolumeDrg() + ", postAcuteCare=" + this.getPostAcuteCare() + ", specialPaymentPostAcuteCare=" + this.getSpecialPaymentPostAcuteCare() + ", weight=" + this.getWeight() + ")";
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String ARITHMETIC_MEAN_LENGTH_OF_STAY = "arithmeticMeanLengthOfStay";
    public static final java.lang.String DIAGNOSTIC_RELATED_GROUP = "diagnosticRelatedGroup";
    public static final java.lang.String DESCRIPTION = "description";
    public static final java.lang.String EFFECTIVE_DATE = "effectiveDate";
    public static final java.lang.String GEOMETRIC_MEAN_LENGTH_OF_STAY = "geometricMeanLengthOfStay";
    public static final java.lang.String LOW_VOLUME_DRG = "lowVolumeDrg";
    public static final java.lang.String POST_ACUTE_CARE = "postAcuteCare";
    public static final java.lang.String SPECIAL_PAYMENT_POST_ACUTE_CARE = "specialPaymentPostAcuteCare";
    public static final java.lang.String WEIGHT = "weight";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DrgsTableEntry() {
  }
}
