// Generated by delombok at Mon Oct 04 13:52:54 EDT 2021
package gov.cms.fiss.pricers.ipps.api;

import gov.cms.fiss.pricers.common.api.DateValidationException;
import gov.cms.fiss.pricers.common.api.PricerObj;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Schema(description = "IPPS Claim input")
public class IppsInput extends PricerObj {
  @NotNull
  @Valid
  private BillingRecord billingRecord;
  @NotNull
  @Valid
  private ProviderRecord providerRecord;

  public void validate() throws DateValidationException {
    final List<String> invalid = new ArrayList<>();
    DateFormat formatter = new SimpleDateFormat("yyyyMMdd");
    formatter.setLenient(false);
    try {
      DateTimeFormatter.BASIC_ISO_DATE.parse(this.billingRecord.getDischargeDate());
    } catch (DateTimeParseException e) {
      invalid.add("dischargeDate");
    }
    try {
      DateTimeFormatter.BASIC_ISO_DATE.parse(this.providerRecord.getEffectiveDate());
    } catch (DateTimeParseException e) {
      invalid.add("effectiveDate");
    }
    if (!invalid.isEmpty()) {
      throw new DateValidationException("Could not parse all dates provided.", invalid);
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IppsInput() {
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BillingRecord getBillingRecord() {
    return this.billingRecord;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ProviderRecord getProviderRecord() {
    return this.providerRecord;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingRecord(final BillingRecord billingRecord) {
    this.billingRecord = billingRecord;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProviderRecord(final ProviderRecord providerRecord) {
    this.providerRecord = providerRecord;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof IppsInput)) return false;
    final IppsInput other = (IppsInput) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$billingRecord = this.getBillingRecord();
    final java.lang.Object other$billingRecord = other.getBillingRecord();
    if (this$billingRecord == null ? other$billingRecord != null : !this$billingRecord.equals(other$billingRecord)) return false;
    final java.lang.Object this$providerRecord = this.getProviderRecord();
    final java.lang.Object other$providerRecord = other.getProviderRecord();
    if (this$providerRecord == null ? other$providerRecord != null : !this$providerRecord.equals(other$providerRecord)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof IppsInput;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $billingRecord = this.getBillingRecord();
    result = result * PRIME + ($billingRecord == null ? 43 : $billingRecord.hashCode());
    final java.lang.Object $providerRecord = this.getProviderRecord();
    result = result * PRIME + ($providerRecord == null ? 43 : $providerRecord.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "IppsInput(billingRecord=" + this.getBillingRecord() + ", providerRecord=" + this.getProviderRecord() + ")";
  }
}
