// Generated by delombok at Mon Oct 04 13:52:54 EDT 2021
package gov.cms.fiss.pricers.ipps.api;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

/**
 * Output values for the IppsPricer calculation
 */
@BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
public class ProspectivePaymentRecord {
  @NotNull
  private int rtc;
  @NotNull
  private int outlierDays;
  @NotNull
  private int regDaysUsed;
  @NotNull
  private int ltrDaysUsed;
  @NotNull
  private String calcVers = "00000";
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @NotNull
  @DecimalMin("00.0000")
  @DecimalMax("99.9999")
  @Digits(integer = 2, fraction = 4)
  private BigDecimal wageIndx = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 1, roundingMode = RoundingMode.HALF_UP)
  @NotNull
  @DecimalMin("00.0")
  @DecimalMax("99.9")
  @Digits(integer = 2, fraction = 1)
  private BigDecimal avgLos = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
  // Changed to double as Sam Wiley is sending integers in their Json. Perhaps it should be
  // int but at least double made the tests pass. Let's discuss.
  @BigDecimalScale(scale = 1, roundingMode = RoundingMode.HALF_UP)
  @NotNull
  @DecimalMin("00.0")
  @DecimalMax("99.9")
  @Digits(integer = 2, fraction = 1)
  private BigDecimal daysCutoff = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
  @NotNull
  @DecimalMin("000000.00")
  @DecimalMax("999999.99")
  @Digits(integer = 6, fraction = 2)
  private BigDecimal operImeAdj = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @NotNull
  @DecimalMin("000000.00")
  @DecimalMax("999999.99")
  @Digits(integer = 6, fraction = 2)
  private BigDecimal totalPayment = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @NotNull
  @DecimalMin("000000.00")
  @DecimalMax("999999.99")
  @Digits(integer = 6, fraction = 2)
  private BigDecimal operHspPart = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @NotNull
  @DecimalMin("000000.00")
  @DecimalMax("999999.99")
  @Digits(integer = 6, fraction = 2)
  private BigDecimal operFspPart = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @NotNull
  @DecimalMin("000000.00")
  @DecimalMax("999999.99")
  @Digits(integer = 6, fraction = 2)
  private BigDecimal operOutlierPart = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @NotNull
  @DecimalMin("000000.00")
  @DecimalMax("999999.99")
  @Digits(integer = 6, fraction = 2)
  private BigDecimal operDshAdj = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);

  public ProspectivePaymentRecord(ProspectivePaymentRecord record) {
    this.rtc = record.rtc;
    this.outlierDays = record.outlierDays;
    this.regDaysUsed = record.regDaysUsed;
    this.ltrDaysUsed = record.ltrDaysUsed;
    this.calcVers = record.calcVers;
    this.wageIndx = record.wageIndx;
    this.avgLos = record.avgLos;
    this.daysCutoff = record.daysCutoff;
    this.operImeAdj = record.operImeAdj;
    this.totalPayment = record.totalPayment;
    this.operHspPart = record.operHspPart;
    this.operFspPart = record.operFspPart;
    this.operOutlierPart = record.operOutlierPart;
    this.operDshAdj = record.operDshAdj;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getRtc() {
    return this.rtc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getOutlierDays() {
    return this.outlierDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getRegDaysUsed() {
    return this.regDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLtrDaysUsed() {
    return this.ltrDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCalcVers() {
    return this.calcVers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWageIndx() {
    return this.wageIndx;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAvgLos() {
    return this.avgLos;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDaysCutoff() {
    return this.daysCutoff;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperImeAdj() {
    return this.operImeAdj;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalPayment() {
    return this.totalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperHspPart() {
    return this.operHspPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperFspPart() {
    return this.operFspPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperOutlierPart() {
    return this.operOutlierPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperDshAdj() {
    return this.operDshAdj;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRtc(final int rtc) {
    this.rtc = rtc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierDays(final int outlierDays) {
    this.outlierDays = outlierDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegDaysUsed(final int regDaysUsed) {
    this.regDaysUsed = regDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLtrDaysUsed(final int ltrDaysUsed) {
    this.ltrDaysUsed = ltrDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCalcVers(final String calcVers) {
    this.calcVers = calcVers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWageIndx(final BigDecimal wageIndx) {
    this.wageIndx = wageIndx;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAvgLos(final BigDecimal avgLos) {
    this.avgLos = avgLos;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDaysCutoff(final BigDecimal daysCutoff) {
    this.daysCutoff = daysCutoff;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperImeAdj(final BigDecimal operImeAdj) {
    this.operImeAdj = operImeAdj;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalPayment(final BigDecimal totalPayment) {
    this.totalPayment = totalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperHspPart(final BigDecimal operHspPart) {
    this.operHspPart = operHspPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperFspPart(final BigDecimal operFspPart) {
    this.operFspPart = operFspPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperOutlierPart(final BigDecimal operOutlierPart) {
    this.operOutlierPart = operOutlierPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperDshAdj(final BigDecimal operDshAdj) {
    this.operDshAdj = operDshAdj;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ProspectivePaymentRecord)) return false;
    final ProspectivePaymentRecord other = (ProspectivePaymentRecord) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (this.getRtc() != other.getRtc()) return false;
    if (this.getOutlierDays() != other.getOutlierDays()) return false;
    if (this.getRegDaysUsed() != other.getRegDaysUsed()) return false;
    if (this.getLtrDaysUsed() != other.getLtrDaysUsed()) return false;
    final java.lang.Object this$calcVers = this.getCalcVers();
    final java.lang.Object other$calcVers = other.getCalcVers();
    if (this$calcVers == null ? other$calcVers != null : !this$calcVers.equals(other$calcVers)) return false;
    final java.lang.Object this$wageIndx = this.getWageIndx();
    final java.lang.Object other$wageIndx = other.getWageIndx();
    if (this$wageIndx == null ? other$wageIndx != null : !this$wageIndx.equals(other$wageIndx)) return false;
    final java.lang.Object this$avgLos = this.getAvgLos();
    final java.lang.Object other$avgLos = other.getAvgLos();
    if (this$avgLos == null ? other$avgLos != null : !this$avgLos.equals(other$avgLos)) return false;
    final java.lang.Object this$daysCutoff = this.getDaysCutoff();
    final java.lang.Object other$daysCutoff = other.getDaysCutoff();
    if (this$daysCutoff == null ? other$daysCutoff != null : !this$daysCutoff.equals(other$daysCutoff)) return false;
    final java.lang.Object this$operImeAdj = this.getOperImeAdj();
    final java.lang.Object other$operImeAdj = other.getOperImeAdj();
    if (this$operImeAdj == null ? other$operImeAdj != null : !this$operImeAdj.equals(other$operImeAdj)) return false;
    final java.lang.Object this$totalPayment = this.getTotalPayment();
    final java.lang.Object other$totalPayment = other.getTotalPayment();
    if (this$totalPayment == null ? other$totalPayment != null : !this$totalPayment.equals(other$totalPayment)) return false;
    final java.lang.Object this$operHspPart = this.getOperHspPart();
    final java.lang.Object other$operHspPart = other.getOperHspPart();
    if (this$operHspPart == null ? other$operHspPart != null : !this$operHspPart.equals(other$operHspPart)) return false;
    final java.lang.Object this$operFspPart = this.getOperFspPart();
    final java.lang.Object other$operFspPart = other.getOperFspPart();
    if (this$operFspPart == null ? other$operFspPart != null : !this$operFspPart.equals(other$operFspPart)) return false;
    final java.lang.Object this$operOutlierPart = this.getOperOutlierPart();
    final java.lang.Object other$operOutlierPart = other.getOperOutlierPart();
    if (this$operOutlierPart == null ? other$operOutlierPart != null : !this$operOutlierPart.equals(other$operOutlierPart)) return false;
    final java.lang.Object this$operDshAdj = this.getOperDshAdj();
    final java.lang.Object other$operDshAdj = other.getOperDshAdj();
    if (this$operDshAdj == null ? other$operDshAdj != null : !this$operDshAdj.equals(other$operDshAdj)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ProspectivePaymentRecord;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    result = result * PRIME + this.getRtc();
    result = result * PRIME + this.getOutlierDays();
    result = result * PRIME + this.getRegDaysUsed();
    result = result * PRIME + this.getLtrDaysUsed();
    final java.lang.Object $calcVers = this.getCalcVers();
    result = result * PRIME + ($calcVers == null ? 43 : $calcVers.hashCode());
    final java.lang.Object $wageIndx = this.getWageIndx();
    result = result * PRIME + ($wageIndx == null ? 43 : $wageIndx.hashCode());
    final java.lang.Object $avgLos = this.getAvgLos();
    result = result * PRIME + ($avgLos == null ? 43 : $avgLos.hashCode());
    final java.lang.Object $daysCutoff = this.getDaysCutoff();
    result = result * PRIME + ($daysCutoff == null ? 43 : $daysCutoff.hashCode());
    final java.lang.Object $operImeAdj = this.getOperImeAdj();
    result = result * PRIME + ($operImeAdj == null ? 43 : $operImeAdj.hashCode());
    final java.lang.Object $totalPayment = this.getTotalPayment();
    result = result * PRIME + ($totalPayment == null ? 43 : $totalPayment.hashCode());
    final java.lang.Object $operHspPart = this.getOperHspPart();
    result = result * PRIME + ($operHspPart == null ? 43 : $operHspPart.hashCode());
    final java.lang.Object $operFspPart = this.getOperFspPart();
    result = result * PRIME + ($operFspPart == null ? 43 : $operFspPart.hashCode());
    final java.lang.Object $operOutlierPart = this.getOperOutlierPart();
    result = result * PRIME + ($operOutlierPart == null ? 43 : $operOutlierPart.hashCode());
    final java.lang.Object $operDshAdj = this.getOperDshAdj();
    result = result * PRIME + ($operDshAdj == null ? 43 : $operDshAdj.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "ProspectivePaymentRecord(rtc=" + this.getRtc() + ", outlierDays=" + this.getOutlierDays() + ", regDaysUsed=" + this.getRegDaysUsed() + ", ltrDaysUsed=" + this.getLtrDaysUsed() + ", calcVers=" + this.getCalcVers() + ", wageIndx=" + this.getWageIndx() + ", avgLos=" + this.getAvgLos() + ", daysCutoff=" + this.getDaysCutoff() + ", operImeAdj=" + this.getOperImeAdj() + ", totalPayment=" + this.getTotalPayment() + ", operHspPart=" + this.getOperHspPart() + ", operFspPart=" + this.getOperFspPart() + ", operOutlierPart=" + this.getOperOutlierPart() + ", operDshAdj=" + this.getOperDshAdj() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ProspectivePaymentRecord() {
  }
}
