// Generated by delombok at Mon Oct 04 13:52:54 EDT 2021
package gov.cms.fiss.pricers.ipps.api;

import gov.cms.fiss.pricers.common.api.RecordBase;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class ProviderRecord extends RecordBase {
  @Schema(description = "Effective Date of provider record. This cannot be empty.", example = "20181001")
  @NotBlank
  @Pattern(regexp = "\\d{8}")
  private String effectiveDate;
  @Schema(description = "Fiscal Year begin of provider record. This cannot be empty.", example = "20181001")
  @NotBlank
  @Size(min = 8, max = 8)
  private String fiscalYearBeginDate;
  @Schema(description = "Report date of provider record. This cannot be empty.", example = "00000000")
  @NotBlank
  @Size(min = 1, max = 8)
  private String reportDate;
  @Schema(description = "Capital PPS pay code of provider record.", example = "B")
  @Size(max = 1)
  private String capitalPpsPayCode;
  @Schema(description = "Current Census Division of provider record", example = "4")
  @NotNull
  private Integer currentCensusDivision;
  @Schema(description = "Bed size of provider record", example = "0")
  @NotNull
  private Integer bedSize;
  @Schema(description = "Cost of living adjustment of provider record", example = "0.123")
  @DecimalMin("0.000")
  @DecimalMax("9.999")
  @NotNull
  private BigDecimal costOfLivingAdjustment;
  @Schema(description = "Cost to charge ratio of provider record", example = "0.561")
  @DecimalMin("0.000")
  @DecimalMax("9.999")
  @NotNull
  private BigDecimal costToChargeRatio;
  @Schema(description = "SSI ratio of provider record", example = ".0093")
  @DecimalMin("0.0000")
  @DecimalMax("0.9999")
  @NotNull
  private BigDecimal ssiRatio;
  @Schema(description = "Medicaid ratio of provider record", example = ".0591")
  @DecimalMin("0.0000")
  @DecimalMax("0.9999")
  @NotNull
  private BigDecimal medicaidRatio;
  @Schema(description = "Capital cost to charge ratio of provider record", example = "2.456")
  @DecimalMin("0.000")
  @DecimalMax("9.999")
  @NotNull
  private BigDecimal capitalCostToChargeRatio;
  @Schema(description = "Intern to bed ratio of provider record", example = "0.5325")
  @DecimalMin("0.0000")
  @DecimalMax("9.9999")
  @NotNull
  private BigDecimal internToBedRatio;
  @Schema(description = "Case mix index of provider record", example = "0.0453")
  @DecimalMin("0.0000")
  @DecimalMax("9.9999")
  @NotNull
  private BigDecimal caseMixIndex;
  @Schema(description = "Special Provider update factor of provider record", example = "0.04684")
  @DecimalMin("0.00000")
  @DecimalMax("9.99999")
  @NotNull
  private BigDecimal specialProviderUpdateFactor;
  @Schema(description = "Disproportionate shared adjustment percentage of provider record", example = "0.1054")
  @DecimalMin("0.0000")
  @DecimalMax("0.9999")
  @NotNull
  private BigDecimal disproportionateShareAdjustmentPercent;
  @Schema(description = "Pass through capital amount of provider record", example = "5466.54")
  @DecimalMin("0000.00")
  @DecimalMax("9999.99")
  @NotNull
  private BigDecimal passthruAmountCapital;
  @Schema(description = "Pass through amount of direct medical education of provider record", example = "5466.54")
  @DecimalMin("0000.00")
  @DecimalMax("9999.99")
  @NotNull
  private BigDecimal passthruAmountDirectMedicalEducation;
  @Schema(description = "Pass through amount of organ acquisition of provider record", example = "5466.54")
  @DecimalMin("0000.00")
  @DecimalMax("9999.99")
  @NotNull
  private BigDecimal passthruAmountOrganAcquisition;
  @Schema(description = "Pass through amount plus miscellaneous of provider record", example = "5466.54")
  @DecimalMin("0000.00")
  @DecimalMax("9999.99")
  @NotNull
  private BigDecimal passthruAmountPlusMisc;
  @Schema(description = "Capital PPS hospital specific rate of provider record", example = "5466.54")
  @DecimalMin("0000.00")
  @DecimalMax("9999.99")
  @NotNull
  private BigDecimal capitalPpsHospitalSpecificRate;
  @Schema(description = "Old Capital Hold Harmless rate of provider record", example = "5466.54")
  @DecimalMin("0000.00")
  @DecimalMax("9999.99")
  @NotNull
  private BigDecimal oldCapitalHoldHarmlessRate;
  @Schema(description = "New Capital Hold Harmless rate of provider record", example = "0.0121")
  @DecimalMin("0.0000")
  @DecimalMax("9.9999")
  @NotNull
  private BigDecimal newCapitalHoldHarmlessRatio;
  @Schema(description = "Capital Indirect Medical Education Ratio of provider record", example = "0.0321")
  @DecimalMin("0.0000")
  @DecimalMax("9.9999")
  @NotNull
  private BigDecimal capitalIndirectMedicalEducationRatio;
  @Schema(description = "Capital Exception Payment rate of provider record", example = "5466.54")
  @DecimalMin("0000.00")
  @DecimalMax("9999.99")
  @NotNull
  private BigDecimal capitalExceptionPaymentRate;
  @Schema(description = "Pass Thru Amount for Allogeneic Stem Cell Acquisition of provider record", example = "1234.56")
  @DecimalMin("0000000.00")
  @DecimalMax("9999999.99")
  private BigDecimal passThruAlloStemCell;
  @Schema(description = "Value Based Purchase Score of provider record", example = "2.456789123")
  @DecimalMin("0.00000000000")
  @DecimalMax("9.99999999999")
  @NotNull
  private BigDecimal valueBasedPurchaseScore;
  @Schema(description = "Waiver code of provider record", example = "N")
  @Size(max = 1)
  private String waiverCode;
  @Schema(description = "Intermediary number of provider record", example = "0")
  private Integer intermediaryNumber;
  @Schema(description = "Provider type of provider record", example = "04")
  @Size(max = 2)
  private String providerType;
  @Schema(description = "Sole community hospital year of provider record", example = "00")
  @Size(max = 2)
  private String soleCommunityHospitalYear;
  @Schema(description = "Lugar reclass code of provider record", example = "0")
  @Size(max = 1)
  private String lugarReclassCode;
  @Schema(description = "Temporary relief indicator of provider record", example = " ")
  @Size(max = 1)
  private String temporaryReliefIndicator;
  @Schema(description = "Federal PPS Blend indicator of provider record", example = "4")
  @Size(max = 1)
  private String federalPpsBlendIndicator;
  @Schema(description = "PPS Blend year indicator of provider record", example = "0")
  @Max(9)
  @Min(0)
  private Integer ppsBlendYearIndicator;
  @Schema(description = "New Hospital indicator of provider record", example = " ")
  @Size(max = 1)
  private String newHospitalIndicator;
  @Schema(description = "Fiscal Year end of provider record", example = "20190930")
  @Size(max = 8)
  private String fiscalYearEndDate;
  @Schema(description = "MSA Data")
  @NotNull
  @Valid
  private MsaData msaData;
  @Schema(description = "CBSA Data")
  @NotNull
  @Valid
  private CbsaData cbsaData;
  @Schema(description = "New County Code. Format String. This field cannot be empty.", example = "36105")
  @NotBlank
  @Size(min = 1, max = 5)
  private String newCountyCode;
  @Schema(description = "Termination Date. Format YYYYMMDD, where YYYY=Year MM=Month DD=Day of Month. " + "This field cannot be empty.", example = "000000")
  @NotBlank
  @Size(min = 1, max = 8)
  private String terminationDate;
  @Schema(description = "Uncomp Care Amount. Format BigDecimal rounded to the nearest tenth", example = "800.0")
  @DecimalMin("0000000.00")
  @DecimalMax("9999999.99")
  @NotNull
  private BigDecimal uncompCareAmount;
  @Schema(description = "Facilities Special Rate. Format BigDecimal rounded to the hundreth", example = "333.05")
  @DecimalMin("00000.00")
  @DecimalMax("99999.99")
  @NotNull
  private BigDecimal facilitiesSpecialRate;
  @Schema(description = "Hospital Readmission Adjustment. Format BigDecimal rounded to the nearest ten thousandth", example = "0.9923")
  @DecimalMin("0.0000")
  @DecimalMax("9.9999")
  @NotNull
  private BigDecimal hospitalReadmissionAdjustment;
  @Schema(description = "Model 1 Bundle Disprcnt. Format BigDecimal rounded to the nearest hundredth", example = "0.04")
  @DecimalMin("0.000")
  @DecimalMax("0.999")
  @NotNull
  private BigDecimal model1BundleDisprcnt;
  @Schema(description = "Uncomp Care Amount. Format BigDecimal", example = "0.0")
  @DecimalMin("0.000000")
  @DecimalMax("0.999999")
  @NotNull
  private BigDecimal lvAdjustmentFactor;
  @DecimalMin("00000.00")
  @DecimalMax("99999.99")
  private BigDecimal cmiAdjCpd;
  @DecimalMin("0.0000")
  @DecimalMax("9.9999")
  private BigDecimal hospHrrAdjustmt;
  @Schema(description = "Value Based Purchase Indicator. Format String.", example = "N")
  @Size(max = 1)
  private String valueBasedPurchaseIndicator;
  @Schema(description = "New State Code. Format String", example = "19")
  @Size(max = 2)
  private String newStateCode;
  @Schema(description = "Hospital Readmission Indicator. Format String", example = "1")
  @Size(max = 1)
  private String hospitalReadmissionIndicator = "";
  @Schema(description = "HAC Reduction Indicator. Format String", example = " ")
  @Size(max = 1)
  private String hacReductionIndicator;
  @Schema(description = "EHR Reduction Indicator. Format String, where Y is yes and N is no.", example = "Y")
  @Size(max = 1)
  private String ehrReductionIndicator;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ProviderRecord() {
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEffectiveDate() {
    return this.effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFiscalYearBeginDate() {
    return this.fiscalYearBeginDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReportDate() {
    return this.reportDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCapitalPpsPayCode() {
    return this.capitalPpsPayCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCurrentCensusDivision() {
    return this.currentCensusDivision;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getBedSize() {
    return this.bedSize;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCostOfLivingAdjustment() {
    return this.costOfLivingAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCostToChargeRatio() {
    return this.costToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getSsiRatio() {
    return this.ssiRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getMedicaidRatio() {
    return this.medicaidRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalCostToChargeRatio() {
    return this.capitalCostToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getInternToBedRatio() {
    return this.internToBedRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCaseMixIndex() {
    return this.caseMixIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getSpecialProviderUpdateFactor() {
    return this.specialProviderUpdateFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDisproportionateShareAdjustmentPercent() {
    return this.disproportionateShareAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPassthruAmountCapital() {
    return this.passthruAmountCapital;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPassthruAmountDirectMedicalEducation() {
    return this.passthruAmountDirectMedicalEducation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPassthruAmountOrganAcquisition() {
    return this.passthruAmountOrganAcquisition;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPassthruAmountPlusMisc() {
    return this.passthruAmountPlusMisc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalPpsHospitalSpecificRate() {
    return this.capitalPpsHospitalSpecificRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOldCapitalHoldHarmlessRate() {
    return this.oldCapitalHoldHarmlessRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNewCapitalHoldHarmlessRatio() {
    return this.newCapitalHoldHarmlessRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalIndirectMedicalEducationRatio() {
    return this.capitalIndirectMedicalEducationRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCapitalExceptionPaymentRate() {
    return this.capitalExceptionPaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPassThruAlloStemCell() {
    return this.passThruAlloStemCell;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getValueBasedPurchaseScore() {
    return this.valueBasedPurchaseScore;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getWaiverCode() {
    return this.waiverCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getIntermediaryNumber() {
    return this.intermediaryNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProviderType() {
    return this.providerType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSoleCommunityHospitalYear() {
    return this.soleCommunityHospitalYear;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLugarReclassCode() {
    return this.lugarReclassCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTemporaryReliefIndicator() {
    return this.temporaryReliefIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFederalPpsBlendIndicator() {
    return this.federalPpsBlendIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getPpsBlendYearIndicator() {
    return this.ppsBlendYearIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNewHospitalIndicator() {
    return this.newHospitalIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFiscalYearEndDate() {
    return this.fiscalYearEndDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public MsaData getMsaData() {
    return this.msaData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CbsaData getCbsaData() {
    return this.cbsaData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNewCountyCode() {
    return this.newCountyCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTerminationDate() {
    return this.terminationDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getUncompCareAmount() {
    return this.uncompCareAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFacilitiesSpecialRate() {
    return this.facilitiesSpecialRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHospitalReadmissionAdjustment() {
    return this.hospitalReadmissionAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getModel1BundleDisprcnt() {
    return this.model1BundleDisprcnt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLvAdjustmentFactor() {
    return this.lvAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCmiAdjCpd() {
    return this.cmiAdjCpd;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHospHrrAdjustmt() {
    return this.hospHrrAdjustmt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getValueBasedPurchaseIndicator() {
    return this.valueBasedPurchaseIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNewStateCode() {
    return this.newStateCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHospitalReadmissionIndicator() {
    return this.hospitalReadmissionIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHacReductionIndicator() {
    return this.hacReductionIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEhrReductionIndicator() {
    return this.ehrReductionIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEffectiveDate(final String effectiveDate) {
    this.effectiveDate = effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFiscalYearBeginDate(final String fiscalYearBeginDate) {
    this.fiscalYearBeginDate = fiscalYearBeginDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReportDate(final String reportDate) {
    this.reportDate = reportDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalPpsPayCode(final String capitalPpsPayCode) {
    this.capitalPpsPayCode = capitalPpsPayCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrentCensusDivision(final Integer currentCensusDivision) {
    this.currentCensusDivision = currentCensusDivision;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBedSize(final Integer bedSize) {
    this.bedSize = bedSize;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostOfLivingAdjustment(final BigDecimal costOfLivingAdjustment) {
    this.costOfLivingAdjustment = costOfLivingAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostToChargeRatio(final BigDecimal costToChargeRatio) {
    this.costToChargeRatio = costToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSsiRatio(final BigDecimal ssiRatio) {
    this.ssiRatio = ssiRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMedicaidRatio(final BigDecimal medicaidRatio) {
    this.medicaidRatio = medicaidRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalCostToChargeRatio(final BigDecimal capitalCostToChargeRatio) {
    this.capitalCostToChargeRatio = capitalCostToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInternToBedRatio(final BigDecimal internToBedRatio) {
    this.internToBedRatio = internToBedRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaseMixIndex(final BigDecimal caseMixIndex) {
    this.caseMixIndex = caseMixIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSpecialProviderUpdateFactor(final BigDecimal specialProviderUpdateFactor) {
    this.specialProviderUpdateFactor = specialProviderUpdateFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDisproportionateShareAdjustmentPercent(final BigDecimal disproportionateShareAdjustmentPercent) {
    this.disproportionateShareAdjustmentPercent = disproportionateShareAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPassthruAmountCapital(final BigDecimal passthruAmountCapital) {
    this.passthruAmountCapital = passthruAmountCapital;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPassthruAmountDirectMedicalEducation(final BigDecimal passthruAmountDirectMedicalEducation) {
    this.passthruAmountDirectMedicalEducation = passthruAmountDirectMedicalEducation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPassthruAmountOrganAcquisition(final BigDecimal passthruAmountOrganAcquisition) {
    this.passthruAmountOrganAcquisition = passthruAmountOrganAcquisition;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPassthruAmountPlusMisc(final BigDecimal passthruAmountPlusMisc) {
    this.passthruAmountPlusMisc = passthruAmountPlusMisc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalPpsHospitalSpecificRate(final BigDecimal capitalPpsHospitalSpecificRate) {
    this.capitalPpsHospitalSpecificRate = capitalPpsHospitalSpecificRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOldCapitalHoldHarmlessRate(final BigDecimal oldCapitalHoldHarmlessRate) {
    this.oldCapitalHoldHarmlessRate = oldCapitalHoldHarmlessRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNewCapitalHoldHarmlessRatio(final BigDecimal newCapitalHoldHarmlessRatio) {
    this.newCapitalHoldHarmlessRatio = newCapitalHoldHarmlessRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalIndirectMedicalEducationRatio(final BigDecimal capitalIndirectMedicalEducationRatio) {
    this.capitalIndirectMedicalEducationRatio = capitalIndirectMedicalEducationRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapitalExceptionPaymentRate(final BigDecimal capitalExceptionPaymentRate) {
    this.capitalExceptionPaymentRate = capitalExceptionPaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPassThruAlloStemCell(final BigDecimal passThruAlloStemCell) {
    this.passThruAlloStemCell = passThruAlloStemCell;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValueBasedPurchaseScore(final BigDecimal valueBasedPurchaseScore) {
    this.valueBasedPurchaseScore = valueBasedPurchaseScore;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWaiverCode(final String waiverCode) {
    this.waiverCode = waiverCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIntermediaryNumber(final Integer intermediaryNumber) {
    this.intermediaryNumber = intermediaryNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProviderType(final String providerType) {
    this.providerType = providerType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSoleCommunityHospitalYear(final String soleCommunityHospitalYear) {
    this.soleCommunityHospitalYear = soleCommunityHospitalYear;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLugarReclassCode(final String lugarReclassCode) {
    this.lugarReclassCode = lugarReclassCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTemporaryReliefIndicator(final String temporaryReliefIndicator) {
    this.temporaryReliefIndicator = temporaryReliefIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalPpsBlendIndicator(final String federalPpsBlendIndicator) {
    this.federalPpsBlendIndicator = federalPpsBlendIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPpsBlendYearIndicator(final Integer ppsBlendYearIndicator) {
    this.ppsBlendYearIndicator = ppsBlendYearIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNewHospitalIndicator(final String newHospitalIndicator) {
    this.newHospitalIndicator = newHospitalIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFiscalYearEndDate(final String fiscalYearEndDate) {
    this.fiscalYearEndDate = fiscalYearEndDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMsaData(final MsaData msaData) {
    this.msaData = msaData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCbsaData(final CbsaData cbsaData) {
    this.cbsaData = cbsaData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNewCountyCode(final String newCountyCode) {
    this.newCountyCode = newCountyCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTerminationDate(final String terminationDate) {
    this.terminationDate = terminationDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUncompCareAmount(final BigDecimal uncompCareAmount) {
    this.uncompCareAmount = uncompCareAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFacilitiesSpecialRate(final BigDecimal facilitiesSpecialRate) {
    this.facilitiesSpecialRate = facilitiesSpecialRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospitalReadmissionAdjustment(final BigDecimal hospitalReadmissionAdjustment) {
    this.hospitalReadmissionAdjustment = hospitalReadmissionAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setModel1BundleDisprcnt(final BigDecimal model1BundleDisprcnt) {
    this.model1BundleDisprcnt = model1BundleDisprcnt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLvAdjustmentFactor(final BigDecimal lvAdjustmentFactor) {
    this.lvAdjustmentFactor = lvAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCmiAdjCpd(final BigDecimal cmiAdjCpd) {
    this.cmiAdjCpd = cmiAdjCpd;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospHrrAdjustmt(final BigDecimal hospHrrAdjustmt) {
    this.hospHrrAdjustmt = hospHrrAdjustmt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValueBasedPurchaseIndicator(final String valueBasedPurchaseIndicator) {
    this.valueBasedPurchaseIndicator = valueBasedPurchaseIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNewStateCode(final String newStateCode) {
    this.newStateCode = newStateCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospitalReadmissionIndicator(final String hospitalReadmissionIndicator) {
    this.hospitalReadmissionIndicator = hospitalReadmissionIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHacReductionIndicator(final String hacReductionIndicator) {
    this.hacReductionIndicator = hacReductionIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEhrReductionIndicator(final String ehrReductionIndicator) {
    this.ehrReductionIndicator = ehrReductionIndicator;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ProviderRecord)) return false;
    final ProviderRecord other = (ProviderRecord) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$currentCensusDivision = this.getCurrentCensusDivision();
    final java.lang.Object other$currentCensusDivision = other.getCurrentCensusDivision();
    if (this$currentCensusDivision == null ? other$currentCensusDivision != null : !this$currentCensusDivision.equals(other$currentCensusDivision)) return false;
    final java.lang.Object this$bedSize = this.getBedSize();
    final java.lang.Object other$bedSize = other.getBedSize();
    if (this$bedSize == null ? other$bedSize != null : !this$bedSize.equals(other$bedSize)) return false;
    final java.lang.Object this$intermediaryNumber = this.getIntermediaryNumber();
    final java.lang.Object other$intermediaryNumber = other.getIntermediaryNumber();
    if (this$intermediaryNumber == null ? other$intermediaryNumber != null : !this$intermediaryNumber.equals(other$intermediaryNumber)) return false;
    final java.lang.Object this$ppsBlendYearIndicator = this.getPpsBlendYearIndicator();
    final java.lang.Object other$ppsBlendYearIndicator = other.getPpsBlendYearIndicator();
    if (this$ppsBlendYearIndicator == null ? other$ppsBlendYearIndicator != null : !this$ppsBlendYearIndicator.equals(other$ppsBlendYearIndicator)) return false;
    final java.lang.Object this$effectiveDate = this.getEffectiveDate();
    final java.lang.Object other$effectiveDate = other.getEffectiveDate();
    if (this$effectiveDate == null ? other$effectiveDate != null : !this$effectiveDate.equals(other$effectiveDate)) return false;
    final java.lang.Object this$fiscalYearBeginDate = this.getFiscalYearBeginDate();
    final java.lang.Object other$fiscalYearBeginDate = other.getFiscalYearBeginDate();
    if (this$fiscalYearBeginDate == null ? other$fiscalYearBeginDate != null : !this$fiscalYearBeginDate.equals(other$fiscalYearBeginDate)) return false;
    final java.lang.Object this$reportDate = this.getReportDate();
    final java.lang.Object other$reportDate = other.getReportDate();
    if (this$reportDate == null ? other$reportDate != null : !this$reportDate.equals(other$reportDate)) return false;
    final java.lang.Object this$capitalPpsPayCode = this.getCapitalPpsPayCode();
    final java.lang.Object other$capitalPpsPayCode = other.getCapitalPpsPayCode();
    if (this$capitalPpsPayCode == null ? other$capitalPpsPayCode != null : !this$capitalPpsPayCode.equals(other$capitalPpsPayCode)) return false;
    final java.lang.Object this$costOfLivingAdjustment = this.getCostOfLivingAdjustment();
    final java.lang.Object other$costOfLivingAdjustment = other.getCostOfLivingAdjustment();
    if (this$costOfLivingAdjustment == null ? other$costOfLivingAdjustment != null : !this$costOfLivingAdjustment.equals(other$costOfLivingAdjustment)) return false;
    final java.lang.Object this$costToChargeRatio = this.getCostToChargeRatio();
    final java.lang.Object other$costToChargeRatio = other.getCostToChargeRatio();
    if (this$costToChargeRatio == null ? other$costToChargeRatio != null : !this$costToChargeRatio.equals(other$costToChargeRatio)) return false;
    final java.lang.Object this$ssiRatio = this.getSsiRatio();
    final java.lang.Object other$ssiRatio = other.getSsiRatio();
    if (this$ssiRatio == null ? other$ssiRatio != null : !this$ssiRatio.equals(other$ssiRatio)) return false;
    final java.lang.Object this$medicaidRatio = this.getMedicaidRatio();
    final java.lang.Object other$medicaidRatio = other.getMedicaidRatio();
    if (this$medicaidRatio == null ? other$medicaidRatio != null : !this$medicaidRatio.equals(other$medicaidRatio)) return false;
    final java.lang.Object this$capitalCostToChargeRatio = this.getCapitalCostToChargeRatio();
    final java.lang.Object other$capitalCostToChargeRatio = other.getCapitalCostToChargeRatio();
    if (this$capitalCostToChargeRatio == null ? other$capitalCostToChargeRatio != null : !this$capitalCostToChargeRatio.equals(other$capitalCostToChargeRatio)) return false;
    final java.lang.Object this$internToBedRatio = this.getInternToBedRatio();
    final java.lang.Object other$internToBedRatio = other.getInternToBedRatio();
    if (this$internToBedRatio == null ? other$internToBedRatio != null : !this$internToBedRatio.equals(other$internToBedRatio)) return false;
    final java.lang.Object this$caseMixIndex = this.getCaseMixIndex();
    final java.lang.Object other$caseMixIndex = other.getCaseMixIndex();
    if (this$caseMixIndex == null ? other$caseMixIndex != null : !this$caseMixIndex.equals(other$caseMixIndex)) return false;
    final java.lang.Object this$specialProviderUpdateFactor = this.getSpecialProviderUpdateFactor();
    final java.lang.Object other$specialProviderUpdateFactor = other.getSpecialProviderUpdateFactor();
    if (this$specialProviderUpdateFactor == null ? other$specialProviderUpdateFactor != null : !this$specialProviderUpdateFactor.equals(other$specialProviderUpdateFactor)) return false;
    final java.lang.Object this$disproportionateShareAdjustmentPercent = this.getDisproportionateShareAdjustmentPercent();
    final java.lang.Object other$disproportionateShareAdjustmentPercent = other.getDisproportionateShareAdjustmentPercent();
    if (this$disproportionateShareAdjustmentPercent == null ? other$disproportionateShareAdjustmentPercent != null : !this$disproportionateShareAdjustmentPercent.equals(other$disproportionateShareAdjustmentPercent)) return false;
    final java.lang.Object this$passthruAmountCapital = this.getPassthruAmountCapital();
    final java.lang.Object other$passthruAmountCapital = other.getPassthruAmountCapital();
    if (this$passthruAmountCapital == null ? other$passthruAmountCapital != null : !this$passthruAmountCapital.equals(other$passthruAmountCapital)) return false;
    final java.lang.Object this$passthruAmountDirectMedicalEducation = this.getPassthruAmountDirectMedicalEducation();
    final java.lang.Object other$passthruAmountDirectMedicalEducation = other.getPassthruAmountDirectMedicalEducation();
    if (this$passthruAmountDirectMedicalEducation == null ? other$passthruAmountDirectMedicalEducation != null : !this$passthruAmountDirectMedicalEducation.equals(other$passthruAmountDirectMedicalEducation)) return false;
    final java.lang.Object this$passthruAmountOrganAcquisition = this.getPassthruAmountOrganAcquisition();
    final java.lang.Object other$passthruAmountOrganAcquisition = other.getPassthruAmountOrganAcquisition();
    if (this$passthruAmountOrganAcquisition == null ? other$passthruAmountOrganAcquisition != null : !this$passthruAmountOrganAcquisition.equals(other$passthruAmountOrganAcquisition)) return false;
    final java.lang.Object this$passthruAmountPlusMisc = this.getPassthruAmountPlusMisc();
    final java.lang.Object other$passthruAmountPlusMisc = other.getPassthruAmountPlusMisc();
    if (this$passthruAmountPlusMisc == null ? other$passthruAmountPlusMisc != null : !this$passthruAmountPlusMisc.equals(other$passthruAmountPlusMisc)) return false;
    final java.lang.Object this$capitalPpsHospitalSpecificRate = this.getCapitalPpsHospitalSpecificRate();
    final java.lang.Object other$capitalPpsHospitalSpecificRate = other.getCapitalPpsHospitalSpecificRate();
    if (this$capitalPpsHospitalSpecificRate == null ? other$capitalPpsHospitalSpecificRate != null : !this$capitalPpsHospitalSpecificRate.equals(other$capitalPpsHospitalSpecificRate)) return false;
    final java.lang.Object this$oldCapitalHoldHarmlessRate = this.getOldCapitalHoldHarmlessRate();
    final java.lang.Object other$oldCapitalHoldHarmlessRate = other.getOldCapitalHoldHarmlessRate();
    if (this$oldCapitalHoldHarmlessRate == null ? other$oldCapitalHoldHarmlessRate != null : !this$oldCapitalHoldHarmlessRate.equals(other$oldCapitalHoldHarmlessRate)) return false;
    final java.lang.Object this$newCapitalHoldHarmlessRatio = this.getNewCapitalHoldHarmlessRatio();
    final java.lang.Object other$newCapitalHoldHarmlessRatio = other.getNewCapitalHoldHarmlessRatio();
    if (this$newCapitalHoldHarmlessRatio == null ? other$newCapitalHoldHarmlessRatio != null : !this$newCapitalHoldHarmlessRatio.equals(other$newCapitalHoldHarmlessRatio)) return false;
    final java.lang.Object this$capitalIndirectMedicalEducationRatio = this.getCapitalIndirectMedicalEducationRatio();
    final java.lang.Object other$capitalIndirectMedicalEducationRatio = other.getCapitalIndirectMedicalEducationRatio();
    if (this$capitalIndirectMedicalEducationRatio == null ? other$capitalIndirectMedicalEducationRatio != null : !this$capitalIndirectMedicalEducationRatio.equals(other$capitalIndirectMedicalEducationRatio)) return false;
    final java.lang.Object this$capitalExceptionPaymentRate = this.getCapitalExceptionPaymentRate();
    final java.lang.Object other$capitalExceptionPaymentRate = other.getCapitalExceptionPaymentRate();
    if (this$capitalExceptionPaymentRate == null ? other$capitalExceptionPaymentRate != null : !this$capitalExceptionPaymentRate.equals(other$capitalExceptionPaymentRate)) return false;
    final java.lang.Object this$passThruAlloStemCell = this.getPassThruAlloStemCell();
    final java.lang.Object other$passThruAlloStemCell = other.getPassThruAlloStemCell();
    if (this$passThruAlloStemCell == null ? other$passThruAlloStemCell != null : !this$passThruAlloStemCell.equals(other$passThruAlloStemCell)) return false;
    final java.lang.Object this$valueBasedPurchaseScore = this.getValueBasedPurchaseScore();
    final java.lang.Object other$valueBasedPurchaseScore = other.getValueBasedPurchaseScore();
    if (this$valueBasedPurchaseScore == null ? other$valueBasedPurchaseScore != null : !this$valueBasedPurchaseScore.equals(other$valueBasedPurchaseScore)) return false;
    final java.lang.Object this$waiverCode = this.getWaiverCode();
    final java.lang.Object other$waiverCode = other.getWaiverCode();
    if (this$waiverCode == null ? other$waiverCode != null : !this$waiverCode.equals(other$waiverCode)) return false;
    final java.lang.Object this$providerType = this.getProviderType();
    final java.lang.Object other$providerType = other.getProviderType();
    if (this$providerType == null ? other$providerType != null : !this$providerType.equals(other$providerType)) return false;
    final java.lang.Object this$soleCommunityHospitalYear = this.getSoleCommunityHospitalYear();
    final java.lang.Object other$soleCommunityHospitalYear = other.getSoleCommunityHospitalYear();
    if (this$soleCommunityHospitalYear == null ? other$soleCommunityHospitalYear != null : !this$soleCommunityHospitalYear.equals(other$soleCommunityHospitalYear)) return false;
    final java.lang.Object this$lugarReclassCode = this.getLugarReclassCode();
    final java.lang.Object other$lugarReclassCode = other.getLugarReclassCode();
    if (this$lugarReclassCode == null ? other$lugarReclassCode != null : !this$lugarReclassCode.equals(other$lugarReclassCode)) return false;
    final java.lang.Object this$temporaryReliefIndicator = this.getTemporaryReliefIndicator();
    final java.lang.Object other$temporaryReliefIndicator = other.getTemporaryReliefIndicator();
    if (this$temporaryReliefIndicator == null ? other$temporaryReliefIndicator != null : !this$temporaryReliefIndicator.equals(other$temporaryReliefIndicator)) return false;
    final java.lang.Object this$federalPpsBlendIndicator = this.getFederalPpsBlendIndicator();
    final java.lang.Object other$federalPpsBlendIndicator = other.getFederalPpsBlendIndicator();
    if (this$federalPpsBlendIndicator == null ? other$federalPpsBlendIndicator != null : !this$federalPpsBlendIndicator.equals(other$federalPpsBlendIndicator)) return false;
    final java.lang.Object this$newHospitalIndicator = this.getNewHospitalIndicator();
    final java.lang.Object other$newHospitalIndicator = other.getNewHospitalIndicator();
    if (this$newHospitalIndicator == null ? other$newHospitalIndicator != null : !this$newHospitalIndicator.equals(other$newHospitalIndicator)) return false;
    final java.lang.Object this$fiscalYearEndDate = this.getFiscalYearEndDate();
    final java.lang.Object other$fiscalYearEndDate = other.getFiscalYearEndDate();
    if (this$fiscalYearEndDate == null ? other$fiscalYearEndDate != null : !this$fiscalYearEndDate.equals(other$fiscalYearEndDate)) return false;
    final java.lang.Object this$msaData = this.getMsaData();
    final java.lang.Object other$msaData = other.getMsaData();
    if (this$msaData == null ? other$msaData != null : !this$msaData.equals(other$msaData)) return false;
    final java.lang.Object this$cbsaData = this.getCbsaData();
    final java.lang.Object other$cbsaData = other.getCbsaData();
    if (this$cbsaData == null ? other$cbsaData != null : !this$cbsaData.equals(other$cbsaData)) return false;
    final java.lang.Object this$newCountyCode = this.getNewCountyCode();
    final java.lang.Object other$newCountyCode = other.getNewCountyCode();
    if (this$newCountyCode == null ? other$newCountyCode != null : !this$newCountyCode.equals(other$newCountyCode)) return false;
    final java.lang.Object this$terminationDate = this.getTerminationDate();
    final java.lang.Object other$terminationDate = other.getTerminationDate();
    if (this$terminationDate == null ? other$terminationDate != null : !this$terminationDate.equals(other$terminationDate)) return false;
    final java.lang.Object this$uncompCareAmount = this.getUncompCareAmount();
    final java.lang.Object other$uncompCareAmount = other.getUncompCareAmount();
    if (this$uncompCareAmount == null ? other$uncompCareAmount != null : !this$uncompCareAmount.equals(other$uncompCareAmount)) return false;
    final java.lang.Object this$facilitiesSpecialRate = this.getFacilitiesSpecialRate();
    final java.lang.Object other$facilitiesSpecialRate = other.getFacilitiesSpecialRate();
    if (this$facilitiesSpecialRate == null ? other$facilitiesSpecialRate != null : !this$facilitiesSpecialRate.equals(other$facilitiesSpecialRate)) return false;
    final java.lang.Object this$hospitalReadmissionAdjustment = this.getHospitalReadmissionAdjustment();
    final java.lang.Object other$hospitalReadmissionAdjustment = other.getHospitalReadmissionAdjustment();
    if (this$hospitalReadmissionAdjustment == null ? other$hospitalReadmissionAdjustment != null : !this$hospitalReadmissionAdjustment.equals(other$hospitalReadmissionAdjustment)) return false;
    final java.lang.Object this$model1BundleDisprcnt = this.getModel1BundleDisprcnt();
    final java.lang.Object other$model1BundleDisprcnt = other.getModel1BundleDisprcnt();
    if (this$model1BundleDisprcnt == null ? other$model1BundleDisprcnt != null : !this$model1BundleDisprcnt.equals(other$model1BundleDisprcnt)) return false;
    final java.lang.Object this$lvAdjustmentFactor = this.getLvAdjustmentFactor();
    final java.lang.Object other$lvAdjustmentFactor = other.getLvAdjustmentFactor();
    if (this$lvAdjustmentFactor == null ? other$lvAdjustmentFactor != null : !this$lvAdjustmentFactor.equals(other$lvAdjustmentFactor)) return false;
    final java.lang.Object this$cmiAdjCpd = this.getCmiAdjCpd();
    final java.lang.Object other$cmiAdjCpd = other.getCmiAdjCpd();
    if (this$cmiAdjCpd == null ? other$cmiAdjCpd != null : !this$cmiAdjCpd.equals(other$cmiAdjCpd)) return false;
    final java.lang.Object this$hospHrrAdjustmt = this.getHospHrrAdjustmt();
    final java.lang.Object other$hospHrrAdjustmt = other.getHospHrrAdjustmt();
    if (this$hospHrrAdjustmt == null ? other$hospHrrAdjustmt != null : !this$hospHrrAdjustmt.equals(other$hospHrrAdjustmt)) return false;
    final java.lang.Object this$valueBasedPurchaseIndicator = this.getValueBasedPurchaseIndicator();
    final java.lang.Object other$valueBasedPurchaseIndicator = other.getValueBasedPurchaseIndicator();
    if (this$valueBasedPurchaseIndicator == null ? other$valueBasedPurchaseIndicator != null : !this$valueBasedPurchaseIndicator.equals(other$valueBasedPurchaseIndicator)) return false;
    final java.lang.Object this$newStateCode = this.getNewStateCode();
    final java.lang.Object other$newStateCode = other.getNewStateCode();
    if (this$newStateCode == null ? other$newStateCode != null : !this$newStateCode.equals(other$newStateCode)) return false;
    final java.lang.Object this$hospitalReadmissionIndicator = this.getHospitalReadmissionIndicator();
    final java.lang.Object other$hospitalReadmissionIndicator = other.getHospitalReadmissionIndicator();
    if (this$hospitalReadmissionIndicator == null ? other$hospitalReadmissionIndicator != null : !this$hospitalReadmissionIndicator.equals(other$hospitalReadmissionIndicator)) return false;
    final java.lang.Object this$hacReductionIndicator = this.getHacReductionIndicator();
    final java.lang.Object other$hacReductionIndicator = other.getHacReductionIndicator();
    if (this$hacReductionIndicator == null ? other$hacReductionIndicator != null : !this$hacReductionIndicator.equals(other$hacReductionIndicator)) return false;
    final java.lang.Object this$ehrReductionIndicator = this.getEhrReductionIndicator();
    final java.lang.Object other$ehrReductionIndicator = other.getEhrReductionIndicator();
    if (this$ehrReductionIndicator == null ? other$ehrReductionIndicator != null : !this$ehrReductionIndicator.equals(other$ehrReductionIndicator)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ProviderRecord;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $currentCensusDivision = this.getCurrentCensusDivision();
    result = result * PRIME + ($currentCensusDivision == null ? 43 : $currentCensusDivision.hashCode());
    final java.lang.Object $bedSize = this.getBedSize();
    result = result * PRIME + ($bedSize == null ? 43 : $bedSize.hashCode());
    final java.lang.Object $intermediaryNumber = this.getIntermediaryNumber();
    result = result * PRIME + ($intermediaryNumber == null ? 43 : $intermediaryNumber.hashCode());
    final java.lang.Object $ppsBlendYearIndicator = this.getPpsBlendYearIndicator();
    result = result * PRIME + ($ppsBlendYearIndicator == null ? 43 : $ppsBlendYearIndicator.hashCode());
    final java.lang.Object $effectiveDate = this.getEffectiveDate();
    result = result * PRIME + ($effectiveDate == null ? 43 : $effectiveDate.hashCode());
    final java.lang.Object $fiscalYearBeginDate = this.getFiscalYearBeginDate();
    result = result * PRIME + ($fiscalYearBeginDate == null ? 43 : $fiscalYearBeginDate.hashCode());
    final java.lang.Object $reportDate = this.getReportDate();
    result = result * PRIME + ($reportDate == null ? 43 : $reportDate.hashCode());
    final java.lang.Object $capitalPpsPayCode = this.getCapitalPpsPayCode();
    result = result * PRIME + ($capitalPpsPayCode == null ? 43 : $capitalPpsPayCode.hashCode());
    final java.lang.Object $costOfLivingAdjustment = this.getCostOfLivingAdjustment();
    result = result * PRIME + ($costOfLivingAdjustment == null ? 43 : $costOfLivingAdjustment.hashCode());
    final java.lang.Object $costToChargeRatio = this.getCostToChargeRatio();
    result = result * PRIME + ($costToChargeRatio == null ? 43 : $costToChargeRatio.hashCode());
    final java.lang.Object $ssiRatio = this.getSsiRatio();
    result = result * PRIME + ($ssiRatio == null ? 43 : $ssiRatio.hashCode());
    final java.lang.Object $medicaidRatio = this.getMedicaidRatio();
    result = result * PRIME + ($medicaidRatio == null ? 43 : $medicaidRatio.hashCode());
    final java.lang.Object $capitalCostToChargeRatio = this.getCapitalCostToChargeRatio();
    result = result * PRIME + ($capitalCostToChargeRatio == null ? 43 : $capitalCostToChargeRatio.hashCode());
    final java.lang.Object $internToBedRatio = this.getInternToBedRatio();
    result = result * PRIME + ($internToBedRatio == null ? 43 : $internToBedRatio.hashCode());
    final java.lang.Object $caseMixIndex = this.getCaseMixIndex();
    result = result * PRIME + ($caseMixIndex == null ? 43 : $caseMixIndex.hashCode());
    final java.lang.Object $specialProviderUpdateFactor = this.getSpecialProviderUpdateFactor();
    result = result * PRIME + ($specialProviderUpdateFactor == null ? 43 : $specialProviderUpdateFactor.hashCode());
    final java.lang.Object $disproportionateShareAdjustmentPercent = this.getDisproportionateShareAdjustmentPercent();
    result = result * PRIME + ($disproportionateShareAdjustmentPercent == null ? 43 : $disproportionateShareAdjustmentPercent.hashCode());
    final java.lang.Object $passthruAmountCapital = this.getPassthruAmountCapital();
    result = result * PRIME + ($passthruAmountCapital == null ? 43 : $passthruAmountCapital.hashCode());
    final java.lang.Object $passthruAmountDirectMedicalEducation = this.getPassthruAmountDirectMedicalEducation();
    result = result * PRIME + ($passthruAmountDirectMedicalEducation == null ? 43 : $passthruAmountDirectMedicalEducation.hashCode());
    final java.lang.Object $passthruAmountOrganAcquisition = this.getPassthruAmountOrganAcquisition();
    result = result * PRIME + ($passthruAmountOrganAcquisition == null ? 43 : $passthruAmountOrganAcquisition.hashCode());
    final java.lang.Object $passthruAmountPlusMisc = this.getPassthruAmountPlusMisc();
    result = result * PRIME + ($passthruAmountPlusMisc == null ? 43 : $passthruAmountPlusMisc.hashCode());
    final java.lang.Object $capitalPpsHospitalSpecificRate = this.getCapitalPpsHospitalSpecificRate();
    result = result * PRIME + ($capitalPpsHospitalSpecificRate == null ? 43 : $capitalPpsHospitalSpecificRate.hashCode());
    final java.lang.Object $oldCapitalHoldHarmlessRate = this.getOldCapitalHoldHarmlessRate();
    result = result * PRIME + ($oldCapitalHoldHarmlessRate == null ? 43 : $oldCapitalHoldHarmlessRate.hashCode());
    final java.lang.Object $newCapitalHoldHarmlessRatio = this.getNewCapitalHoldHarmlessRatio();
    result = result * PRIME + ($newCapitalHoldHarmlessRatio == null ? 43 : $newCapitalHoldHarmlessRatio.hashCode());
    final java.lang.Object $capitalIndirectMedicalEducationRatio = this.getCapitalIndirectMedicalEducationRatio();
    result = result * PRIME + ($capitalIndirectMedicalEducationRatio == null ? 43 : $capitalIndirectMedicalEducationRatio.hashCode());
    final java.lang.Object $capitalExceptionPaymentRate = this.getCapitalExceptionPaymentRate();
    result = result * PRIME + ($capitalExceptionPaymentRate == null ? 43 : $capitalExceptionPaymentRate.hashCode());
    final java.lang.Object $passThruAlloStemCell = this.getPassThruAlloStemCell();
    result = result * PRIME + ($passThruAlloStemCell == null ? 43 : $passThruAlloStemCell.hashCode());
    final java.lang.Object $valueBasedPurchaseScore = this.getValueBasedPurchaseScore();
    result = result * PRIME + ($valueBasedPurchaseScore == null ? 43 : $valueBasedPurchaseScore.hashCode());
    final java.lang.Object $waiverCode = this.getWaiverCode();
    result = result * PRIME + ($waiverCode == null ? 43 : $waiverCode.hashCode());
    final java.lang.Object $providerType = this.getProviderType();
    result = result * PRIME + ($providerType == null ? 43 : $providerType.hashCode());
    final java.lang.Object $soleCommunityHospitalYear = this.getSoleCommunityHospitalYear();
    result = result * PRIME + ($soleCommunityHospitalYear == null ? 43 : $soleCommunityHospitalYear.hashCode());
    final java.lang.Object $lugarReclassCode = this.getLugarReclassCode();
    result = result * PRIME + ($lugarReclassCode == null ? 43 : $lugarReclassCode.hashCode());
    final java.lang.Object $temporaryReliefIndicator = this.getTemporaryReliefIndicator();
    result = result * PRIME + ($temporaryReliefIndicator == null ? 43 : $temporaryReliefIndicator.hashCode());
    final java.lang.Object $federalPpsBlendIndicator = this.getFederalPpsBlendIndicator();
    result = result * PRIME + ($federalPpsBlendIndicator == null ? 43 : $federalPpsBlendIndicator.hashCode());
    final java.lang.Object $newHospitalIndicator = this.getNewHospitalIndicator();
    result = result * PRIME + ($newHospitalIndicator == null ? 43 : $newHospitalIndicator.hashCode());
    final java.lang.Object $fiscalYearEndDate = this.getFiscalYearEndDate();
    result = result * PRIME + ($fiscalYearEndDate == null ? 43 : $fiscalYearEndDate.hashCode());
    final java.lang.Object $msaData = this.getMsaData();
    result = result * PRIME + ($msaData == null ? 43 : $msaData.hashCode());
    final java.lang.Object $cbsaData = this.getCbsaData();
    result = result * PRIME + ($cbsaData == null ? 43 : $cbsaData.hashCode());
    final java.lang.Object $newCountyCode = this.getNewCountyCode();
    result = result * PRIME + ($newCountyCode == null ? 43 : $newCountyCode.hashCode());
    final java.lang.Object $terminationDate = this.getTerminationDate();
    result = result * PRIME + ($terminationDate == null ? 43 : $terminationDate.hashCode());
    final java.lang.Object $uncompCareAmount = this.getUncompCareAmount();
    result = result * PRIME + ($uncompCareAmount == null ? 43 : $uncompCareAmount.hashCode());
    final java.lang.Object $facilitiesSpecialRate = this.getFacilitiesSpecialRate();
    result = result * PRIME + ($facilitiesSpecialRate == null ? 43 : $facilitiesSpecialRate.hashCode());
    final java.lang.Object $hospitalReadmissionAdjustment = this.getHospitalReadmissionAdjustment();
    result = result * PRIME + ($hospitalReadmissionAdjustment == null ? 43 : $hospitalReadmissionAdjustment.hashCode());
    final java.lang.Object $model1BundleDisprcnt = this.getModel1BundleDisprcnt();
    result = result * PRIME + ($model1BundleDisprcnt == null ? 43 : $model1BundleDisprcnt.hashCode());
    final java.lang.Object $lvAdjustmentFactor = this.getLvAdjustmentFactor();
    result = result * PRIME + ($lvAdjustmentFactor == null ? 43 : $lvAdjustmentFactor.hashCode());
    final java.lang.Object $cmiAdjCpd = this.getCmiAdjCpd();
    result = result * PRIME + ($cmiAdjCpd == null ? 43 : $cmiAdjCpd.hashCode());
    final java.lang.Object $hospHrrAdjustmt = this.getHospHrrAdjustmt();
    result = result * PRIME + ($hospHrrAdjustmt == null ? 43 : $hospHrrAdjustmt.hashCode());
    final java.lang.Object $valueBasedPurchaseIndicator = this.getValueBasedPurchaseIndicator();
    result = result * PRIME + ($valueBasedPurchaseIndicator == null ? 43 : $valueBasedPurchaseIndicator.hashCode());
    final java.lang.Object $newStateCode = this.getNewStateCode();
    result = result * PRIME + ($newStateCode == null ? 43 : $newStateCode.hashCode());
    final java.lang.Object $hospitalReadmissionIndicator = this.getHospitalReadmissionIndicator();
    result = result * PRIME + ($hospitalReadmissionIndicator == null ? 43 : $hospitalReadmissionIndicator.hashCode());
    final java.lang.Object $hacReductionIndicator = this.getHacReductionIndicator();
    result = result * PRIME + ($hacReductionIndicator == null ? 43 : $hacReductionIndicator.hashCode());
    final java.lang.Object $ehrReductionIndicator = this.getEhrReductionIndicator();
    result = result * PRIME + ($ehrReductionIndicator == null ? 43 : $ehrReductionIndicator.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "ProviderRecord(effectiveDate=" + this.getEffectiveDate() + ", fiscalYearBeginDate=" + this.getFiscalYearBeginDate() + ", reportDate=" + this.getReportDate() + ", capitalPpsPayCode=" + this.getCapitalPpsPayCode() + ", currentCensusDivision=" + this.getCurrentCensusDivision() + ", bedSize=" + this.getBedSize() + ", costOfLivingAdjustment=" + this.getCostOfLivingAdjustment() + ", costToChargeRatio=" + this.getCostToChargeRatio() + ", ssiRatio=" + this.getSsiRatio() + ", medicaidRatio=" + this.getMedicaidRatio() + ", capitalCostToChargeRatio=" + this.getCapitalCostToChargeRatio() + ", internToBedRatio=" + this.getInternToBedRatio() + ", caseMixIndex=" + this.getCaseMixIndex() + ", specialProviderUpdateFactor=" + this.getSpecialProviderUpdateFactor() + ", disproportionateShareAdjustmentPercent=" + this.getDisproportionateShareAdjustmentPercent() + ", passthruAmountCapital=" + this.getPassthruAmountCapital() + ", passthruAmountDirectMedicalEducation=" + this.getPassthruAmountDirectMedicalEducation() + ", passthruAmountOrganAcquisition=" + this.getPassthruAmountOrganAcquisition() + ", passthruAmountPlusMisc=" + this.getPassthruAmountPlusMisc() + ", capitalPpsHospitalSpecificRate=" + this.getCapitalPpsHospitalSpecificRate() + ", oldCapitalHoldHarmlessRate=" + this.getOldCapitalHoldHarmlessRate() + ", newCapitalHoldHarmlessRatio=" + this.getNewCapitalHoldHarmlessRatio() + ", capitalIndirectMedicalEducationRatio=" + this.getCapitalIndirectMedicalEducationRatio() + ", capitalExceptionPaymentRate=" + this.getCapitalExceptionPaymentRate() + ", passThruAlloStemCell=" + this.getPassThruAlloStemCell() + ", valueBasedPurchaseScore=" + this.getValueBasedPurchaseScore() + ", waiverCode=" + this.getWaiverCode() + ", intermediaryNumber=" + this.getIntermediaryNumber() + ", providerType=" + this.getProviderType() + ", soleCommunityHospitalYear=" + this.getSoleCommunityHospitalYear() + ", lugarReclassCode=" + this.getLugarReclassCode() + ", temporaryReliefIndicator=" + this.getTemporaryReliefIndicator() + ", federalPpsBlendIndicator=" + this.getFederalPpsBlendIndicator() + ", ppsBlendYearIndicator=" + this.getPpsBlendYearIndicator() + ", newHospitalIndicator=" + this.getNewHospitalIndicator() + ", fiscalYearEndDate=" + this.getFiscalYearEndDate() + ", msaData=" + this.getMsaData() + ", cbsaData=" + this.getCbsaData() + ", newCountyCode=" + this.getNewCountyCode() + ", terminationDate=" + this.getTerminationDate() + ", uncompCareAmount=" + this.getUncompCareAmount() + ", facilitiesSpecialRate=" + this.getFacilitiesSpecialRate() + ", hospitalReadmissionAdjustment=" + this.getHospitalReadmissionAdjustment() + ", model1BundleDisprcnt=" + this.getModel1BundleDisprcnt() + ", lvAdjustmentFactor=" + this.getLvAdjustmentFactor() + ", cmiAdjCpd=" + this.getCmiAdjCpd() + ", hospHrrAdjustmt=" + this.getHospHrrAdjustmt() + ", valueBasedPurchaseIndicator=" + this.getValueBasedPurchaseIndicator() + ", newStateCode=" + this.getNewStateCode() + ", hospitalReadmissionIndicator=" + this.getHospitalReadmissionIndicator() + ", hacReductionIndicator=" + this.getHacReductionIndicator() + ", ehrReductionIndicator=" + this.getEhrReductionIndicator() + ")";
  }
}
