package gov.cms.fiss.pricers.ipps.core;

import java.util.Arrays;

public enum ResultCode {
  RC_00_OK(0, "Paid normal CMG payment with outlier"),
  RC_02_TRANSFER_PAID_AS_OUTLIER(2, "Transfer paid as a cost outlier"),
  RC_03_TRANSFER_PAID_PERDIEM_DAYS(3, "Transfer paid on a perdiem basis with outlier"),
  RC_05_TRANSFER_PAID_ON_A_PERDIEM_BASIS(5, "Transfer paid on a perdiem basis up to an amount"),
  RC_06_PAY_XFER_NO_COST(6, "Pay transfer with no cost"),
  RC_10_POST_ACUTE_XFER(10, "Paid normal payment with post a acute transfer"),
  RC_12_POST_ACUTE_XFER_WITH_DRGS(12, "Transfer paid with post acute transfer with specific drgs"),
  RC_14_PAID_DRG_WITH_PERDIEM(14, "Paid normal DRG payment with Perdiem Days"),
  RC_16_PAID_AS_COST_OUTLIER_WITH_PERDIEM(16, "Paid as a cost-outlier with perdiem days"),
  RC_52_INVALID_WAGE_INDEX(52, "Invalid wage index"),
  RC_53_WAIVER_STATE_NOT_CALC(53, "Waiver state – not calculated by PPS"),
  RC_54_INVALID_DRG(54, "DRG on claim not found on table"),
  RC_55_DISCHRG_DT_LT_EFF_START_DT(
      55,
      "Discharge date less than provider effective start date or discharge date less than MSA effective start date for PPS"),
  RC_56_INVALID_LENGTH_OF_STAY(56, "The length of stay provided is invalid"),
  RC_57_REVIEW_CODE_INVALID(57, "The Review Code provided is not a valid code"),
  RC_61_LTR_NOT_NUM_OR_GT60(
      61, "Lifetime reserve days not numeric or Bill-LTR days are greater than 60"),
  RC_62_INVALID_NBR_COVERED_DAYS(62, "Invalid number of covered days"),
  RC_65_PAY_CODE_NOT_ABC(65, "Pay Code in Provider Records not A, B, or C"),
  RC_67_OUTLIER_LOS_GT_COVERED_DAYS(
      67,
      "Cost outlier with length of stay greater than covered days or cost outlier threshold calculation"),
  RC_68_INVALID_VBPF_IN_PSF(68, "Invalid Value Based Purchasing Flag in Provider File");

  private final int code;
  private final String exp;

  ResultCode(int code, final String exp) {
    this.code = code;
    this.exp = exp;
  }

  public static boolean isErrorCode(int code) {
    return code >= 50;
  }

  public static ResultCode fromCode(int code) {
    return Arrays.stream(ResultCode.values())
        .filter(resultCode -> resultCode.getCode() == code)
        .findFirst()
        .orElse(null);
  }

  public int getCode() {
    return this.code;
  }

  public String getExplanation() {
    return this.exp;
  }

  public boolean isError() {
    return isErrorCode(this.code);
  }
}
