package gov.cms.fiss.pricers.ipps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.AdditionalVariables;
import gov.cms.fiss.pricers.ipps.api.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;

/**
 * Initializes secondary variables for the claim response.
 *
 * <p>Converted from the {@code PPCAL} module in the COBOL code.
 *
 * @since 2019
 */
public class DefaultAdditionalVariableUpdate
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final AdditionalVariables additionalVariables = calculationContext.getAdditionalVariables();

    //     MOVE    H-BUNDLE-ADJUST-AMT TO PPS-BUNDLE-ADJUST-AMT.
    additionalVariables.setBundleAdjustmentAmount(calculationContext.getBundleAdjustmentAmount());

    additionalVariables.setCapi2BFsp(calculationContext.getCapital2BFederalSpecificPortionPart());
    additionalVariables.setCapi2BOutlier(calculationContext.getCapital2BOutlierPart());
    additionalVariables.setCapi2PayCode(calculationContext.getCapital2PayCode());
    final BigDecimal capiFSP =
        calculationContext
            .getCapitalFederalSpecificPortionPart()
            .multiply(calculationContext.getCapitalFederalSpecificPortionPct())
            .setScale(2, RoundingMode.HALF_UP);
    additionalVariables.setCapiDshAdjustment(
        calculationContext
            .getCapitalDisproportionateShareHospital()
            .multiply(capiFSP)
            .setScale(2, RoundingMode.HALF_UP));
    additionalVariables.setCapiException(calculationContext.getCapitalExceptionPaymentRate());
    additionalVariables.setCapiFSP(capiFSP);
    additionalVariables.setCapiImeAdjustment(
        calculationContext.getCapitalIndirectMedicalEducationAdj());

    additionalVariables.setCapiOldHarm(
        calculationContext.getCapitalOldHoldHarmless().setScale(2, RoundingMode.HALF_UP));
    additionalVariables.setCapiOutlier(
        calculationContext.getCapitalOutlierPart().setScale(2, RoundingMode.HALF_UP));
    additionalVariables.setCapiTotalPay(
        calculationContext.getCapitalTotalPayment().setScale(2, RoundingMode.HALF_UP));

    additionalVariables.setDischargeFraction(calculationContext.getDischargeFraction());

    additionalVariables.setDrgWT(
        Optional.ofNullable(calculationContext.getDrgsTableEntry())
            .orElse(new DrgsTableEntry())
            .getWeight());
    additionalVariables.setDrgWTFraction(calculationContext.getDrgWeightFraction());

    //     MOVE H-EHR-ADJUST-AMT TO  PPS-EHR-ADJUST-AMT.
    additionalVariables.setEhrAdjustmentAmount(
        calculationContext.getElectronicHealthRecordAdjustmentAmt());

    additionalVariables.setFspPCT(calculationContext.getOperatingFederalSpecificPortionPct());

    //     MOVE WK-HAC-AMOUNT  TO   PPS-HAC-PAYMENT-AMT.
    additionalVariables.setHacPaymentAmount(
        calculationContext.getHospitalAcquiredConditionAmount().setScale(2, RoundingMode.HALF_UP));

    //     MOVE P-HAC-REDUC-IND  TO  PPS-HAC-PROG-REDUC-IND.
    additionalVariables.setHospitalReadmissionReduction(
        calculationContext.getHospitalReadmissionIndicator());
    additionalVariables.setHospitalHrrAdjustment(
        calculationContext.getHospitalReadmissionReductionAdjustment());

    additionalVariables.setIsletIsolPayAddOn(calculationContext.getIsletIsolationPaymentAddOn());

    additionalVariables.setLowVolPayment(
        calculationContext.getLowVolumePayment().setScale(2, RoundingMode.HALF_UP));

    additionalVariables.setNatPCT(calculationContext.getNationalPct());
    additionalVariables.setNewTechPayAddOn(
        calculationContext.getNewTechAddOnPayment().setScale(2, RoundingMode.HALF_UP));

    additionalVariables.setOperBaseDrgPay(calculationContext.getOperatingBaseDrgPayment());
    additionalVariables.setOperDollarThreshold(
        calculationContext.getOperatingDollarThreshold().setScale(9, RoundingMode.HALF_UP));

    //     MOVE    H-READMIS-ADJUST-AMT TO PPS-READMIS-ADJUST-AMT.
    additionalVariables.setReadmissionAdjustmentAmount(
        calculationContext.getReadmissionAdjustmentAmount());

    //      MOVE H-STANDARD-ALLOWED-AMOUNT  TO  PPS-STNDRD-VALUE.
    additionalVariables.setStandardValue(
        calculationContext.getStandardAllowedAmount().setScale(2, RoundingMode.HALF_UP));

    //     MOVE    WK-UNCOMP-CARE-AMOUNT TO PPS-UNCOMP-CARE-AMOUNT.
    additionalVariables.setUncompCareAmount(calculationContext.getUncompensatedCareAmount());

    additionalVariables.setValBasedPurchaseAdjustment(
        calculationContext.getValueBasedPurchasingAdjustment());

    //     MOVE    H-VAL-BASED-PURCH-ADJUST-AMT TO
    //                           PPS-VAL-BASED-PURCH-ADJUST-AMT.
    additionalVariables.setValBasedPurchaseAdjustmentAmount(
        calculationContext.getValueBasedPurchasingAdjustmentAmount());
    additionalVariables.setValBasedPurchaseParticipant(
        calculationContext.getValueBasedPurchasingParticipant());

    calculationContext
        .getProspectivePaymentRecord()
        .setCalcVers(calculationContext.getCalculationVersion());
  }
}
