package gov.cms.fiss.pricers.ipps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.util.List;

/**
 * Encapsulates the main claim processing flow as a sub-sequence of rules.
 *
 * <p>Corresponds to the {@code PPCAL} process flow from COBOL.
 *
 * @since 2019
 */
public class DefaultClaimProcessing
    extends EvaluatingCalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  public DefaultClaimProcessing(
      List<CalculationRule<IppsInput, IppsOutput, IppsPricerContext>> calculationRules) {
    super(calculationRules);
  }

  @Override
  public boolean shouldExecute(IppsPricerContext calculationContext) {
    return ResultCode.RC_52_INVALID_WAGE_INDEX != calculationContext.getResultCode();
  }
}
