package gov.cms.fiss.pricers.ipps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.api.ProspectivePaymentRecord;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

/**
 * Encapsulates the outlier claim processing flow as a sub-sequence of rules.
 *
 * <p>Corresponds to the {@code PPCAL} process flow from COBOL (continued.
 *
 * @since 2019
 */
public class DefaultOutlierPricing
    extends EvaluatingCalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  public DefaultOutlierPricing(
      List<CalculationRule<IppsInput, IppsOutput, IppsPricerContext>> calculationRules) {
    super(calculationRules);
  }

  @Override
  public boolean shouldExecute(IppsPricerContext calculationContext) {
    return ArrayUtils.contains(
        new ResultCode[] {
          ResultCode.RC_00_OK,
          ResultCode.RC_03_TRANSFER_PAID_PERDIEM_DAYS,
          ResultCode.RC_10_POST_ACUTE_XFER,
          ResultCode.RC_12_POST_ACUTE_XFER_WITH_DRGS,
          ResultCode.RC_14_PAID_DRG_WITH_PERDIEM
        },
        calculationContext.getResultCode());
  }

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    // Need to flip outlier reconciliation flag before executing provided rules
    //     IF (PPS-RTC = '00' OR '03' OR '10' OR
    //                   '12' OR '14')
    //        MOVE 'Y' TO OUTLIER-RECON-FLAG
    //        MOVE PPS-DATA TO HLD-PPS-DATA
    //        PERFORM 0200-MAINLINE-CONTROL THRU 0200-EXIT
    //        MOVE HLD-PPS-DATA TO PPS-DATA.
    calculationContext.setOutlierReconciliation(true);
    calculationContext.clearContextState();
    final ProspectivePaymentRecord currentRecord =
        new ProspectivePaymentRecord(calculationContext.getProspectivePaymentRecord());
    final IppsOutput output = calculationContext.getOutput();
    output.setRecord(new ProspectivePaymentRecord());

    super.priceClaim(calculationContext);

    //     IF OUTLIER-RECON-FLAG = 'Y'
    //        MOVE 'N' TO OUTLIER-RECON-FLAG
    //        GO TO 0200-EXIT.
    calculationContext.setOutlierReconciliation(false);
    output.setRecord(currentRecord);

    if (calculationContext.isOutlierAdjustmentEnabled()) {
      calculationContext.adjustResultCodeForOutliers();
    }
  }
}
