package gov.cms.fiss.pricers.ipps.core.rules.billing_validation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.api.ProviderRecord;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import org.apache.commons.lang3.StringUtils;

/**
 * Validates the capital PPS pay code.
 *
 * <p>Converted from {@code 1000-EDIT-THE-BILL-INFO} in the COBOL code (continued).
 *
 * @since 2019
 */
public class ValidateCapitalPpsPayCode
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public boolean shouldExecute(IppsPricerContext calculationContext) {
    return ResultCode.RC_00_OK == calculationContext.getResultCode();
  }

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final ProviderRecord providerRecord = calculationContext.getProviderRecord();

    //     IF PPS-RTC = 00
    //           IF P-NEW-CAPI-NEW-HOSP NOT = 'Y'
    //                 IF P-NEW-CAPI-PPS-PAY-CODE NOT = 'B' AND
    //                                            NOT = 'C'
    //                 MOVE 65 TO PPS-RTC.
    if (!StringUtils.equals(providerRecord.getNewHospitalIndicator(), "Y")
        && !StringUtils.equalsAny(providerRecord.getCapitalPpsPayCode(), "B", "C")) {
      calculationContext.applyResultCode(ResultCode.RC_65_PAY_CODE_NOT_ABC);
    }
  }
}
