package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.api.ProviderRecord;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * Determines the capital indirect medical education amount.
 *
 * <p>Converted from {@code 3000-CALC-PAYMENT} in the COBOL code (continued).
 *
 * @since 2019
 */
public class CalculateCapitalIndirectMedicalEducation
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final ProviderRecord providerRecord = calculationContext.getProviderRecord();

    // ***********************************************************
    // ***  CAPITAL IME TEACH CALCULATION
    //     MOVE 0 TO H-WK-CAPI-IME-TEACH.
    BigDecimal capitalIndirectMedicalEducationRatio = BigDecimal.ZERO;

    //     IF P-NEW-CAPI-IME NUMERIC
    //        IF P-NEW-CAPI-IME > 1.5000
    //           MOVE 1.5000 TO P-NEW-CAPI-IME.
    if (providerRecord.getCapitalIndirectMedicalEducationRatio() != null) {
      capitalIndirectMedicalEducationRatio =
          providerRecord.getCapitalIndirectMedicalEducationRatio();
    }

    if (BigDecimalUtils.isGreaterThan(
        capitalIndirectMedicalEducationRatio, new BigDecimal("1.5"))) {
      capitalIndirectMedicalEducationRatio = new BigDecimal("1.5");
    }

    // *****YEARCHANGE 2009.5 ****************************************
    // ***
    // ***  PER POLICY, WE REMOVED THE .5 MULTIPLER
    // ***
    // ***********************************************************
    //     IF P-NEW-CAPI-IME NUMERIC
    //        COMPUTE H-WK-CAPI-IME-TEACH ROUNDED =
    //         ((2.7183 ** (.2822 * P-NEW-CAPI-IME)) - 1).
    calculationContext.setCapitalIndirectMedicalEducation(
        BigDecimalUtils.pow(
                new BigDecimal("2.7183"),
                new BigDecimal("0.2822").multiply(capitalIndirectMedicalEducationRatio),
                100)
            .subtract(BigDecimal.ONE)
            .setScale(9, RoundingMode.HALF_UP));
  }
}
